"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedDetectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _job_creator_context = require("../../../job_creator_context");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _metric_selector = require("./metric_selector");
var _detector_list = require("./detector_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyRichDetector = {
  agg: null,
  field: null,
  byField: null,
  overField: null,
  partitionField: null,
  excludeFrequent: null,
  description: null,
  customRules: null,
  useNull: null
};
const AdvancedDetectors = ({
  setIsValid
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const {
    fields,
    aggs
  } = _new_job_capabilities_service.newJobCapsService;
  const [modalPayload, setModalPayload] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    setIsValid(jobCreator.detectors.length > 0);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  function closeModal() {
    setModalPayload(null);
  }
  function detectorChangeHandler(dtr, index) {
    if (index === undefined) {
      jobCreator.addDetector(dtr.agg, dtr.field, dtr.byField, dtr.overField, dtr.partitionField, dtr.excludeFrequent, dtr.description, dtr.useNull);
    } else {
      jobCreator.editDetector(dtr.agg, dtr.field, dtr.byField, dtr.overField, dtr.partitionField, dtr.excludeFrequent, dtr.description, index, dtr.useNull);
    }
    jobCreatorUpdate();
    setModalPayload(null);
  }
  function showModal() {
    setModalPayload({
      detector: emptyRichDetector
    });
  }
  function onDeleteJob(i) {
    jobCreator.removeDetector(i);
    jobCreatorUpdate();
  }
  function onEditJob(i) {
    const dtr = jobCreator.richDetectors[i];
    if (dtr !== undefined) {
      setModalPayload({
        detector: dtr,
        index: i
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_detector_list.DetectorList, {
    isActive: true,
    onEditJob: onEditJob,
    onDeleteJob: onDeleteJob
  }), /*#__PURE__*/_react.default.createElement(_metric_selector.MetricSelector, {
    payload: modalPayload,
    fields: fields,
    aggs: aggs,
    detectorChangeHandler: detectorChangeHandler,
    showModal: showModal,
    closeModal: closeModal
  }));
};
exports.AdvancedDetectors = AdvancedDetectors;