"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScrollSizeInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ml_server_info = require("../../../../../../../services/ml_server_info");
var _job_creator_context = require("../../../job_creator_context");
var _description = require("./description");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ScrollSizeInput = () => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.scrollSize);
  const [scrollSizeString, setScrollSize] = (0, _react.useState)(jobCreator.scrollSize === null ? '' : `${jobCreator.scrollSize}`);
  const {
    datafeeds
  } = (0, _ml_server_info.getNewJobDefaults)();
  const scrollSizeDefault = datafeeds.scroll_size !== undefined ? `${datafeeds.scroll_size}` : '';
  (0, _react.useEffect)(() => {
    jobCreator.scrollSize = scrollSizeString === '' ? null : +scrollSizeString;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [scrollSizeString]);
  (0, _react.useEffect)(() => {
    setScrollSize(jobCreator.scrollSize === null ? '' : `${jobCreator.scrollSize}`);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdate]);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.scrollSize);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    min: 0,
    placeholder: scrollSizeDefault,
    value: scrollSizeString === '' ? scrollSizeString : +scrollSizeString,
    onChange: e => setScrollSize(e.target.value),
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardInputScrollSize"
  }));
};
exports.ScrollSizeInput = ScrollSizeInput;