"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CHART_TYPE = exports.AnomalyChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _anomalies = require("../common/anomalies");
var _model_bounds = require("./model_bounds");
var _line = require("./line");
var _scatter = require("./scatter");
var _axes = require("../common/axes");
var _utils = require("../common/utils");
var _loading_wrapper = require("../loading_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let CHART_TYPE;
exports.CHART_TYPE = CHART_TYPE;
(function (CHART_TYPE) {
  CHART_TYPE[CHART_TYPE["LINE"] = 0] = "LINE";
  CHART_TYPE[CHART_TYPE["SCATTER"] = 1] = "SCATTER";
})(CHART_TYPE || (exports.CHART_TYPE = CHART_TYPE = {}));
const AnomalyChart = ({
  chartType,
  chartData = [],
  modelData,
  anomalyData,
  height,
  width,
  loading = false
}) => {
  const data = chartType === CHART_TYPE.SCATTER ? flattenData(chartData) : chartData;
  const xDomain = (0, _utils.getXRange)(data);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width,
      height
    },
    "data-test-subj": `mlAnomalyChart ${CHART_TYPE[chartType]}`
  }, /*#__PURE__*/_react.default.createElement(_loading_wrapper.LoadingWrapper, {
    height: height,
    hasData: data.length > 0,
    loading: loading
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings
  // TODO use the EUI charts theme see src/plugins/charts/public/services/theme/README.md
  , {
    xDomain: xDomain
  }), /*#__PURE__*/_react.default.createElement(_axes.Axes, {
    chartData: data
  }), /*#__PURE__*/_react.default.createElement(_anomalies.Anomalies, {
    anomalyData: anomalyData
  }), /*#__PURE__*/_react.default.createElement(_model_bounds.ModelBounds, {
    modelData: modelData
  }), chartType === CHART_TYPE.LINE && /*#__PURE__*/_react.default.createElement(_line.Line, {
    chartData: data
  }), chartType === CHART_TYPE.SCATTER && /*#__PURE__*/_react.default.createElement(_scatter.Scatter, {
    chartData: data
  }))));
};
exports.AnomalyChart = AnomalyChart;
function flattenData(data) {
  const chartData = data.reduce((p, c) => {
    p.push(...c.values.map(v => ({
      time: c.time,
      value: v.value
    })));
    return p;
  }, []);
  return chartData;
}