"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationJobCreator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _job_creator = require("./job_creator");
var _default_configs = require("./util/default_configs");
var _new_job = require("../../../../../../common/constants/new_job");
var _categorization_job = require("../../../../../../common/constants/categorization_job");
var _categories = require("../../../../../../common/types/categories");
var _general = require("./util/general");
var _results_loader = require("../results_loader");
var _ml_server_info = require("../../../../services/ml_server_info");
var _index_utils = require("../../../../util/index_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CategorizationJobCreator extends _job_creator.JobCreator {
  constructor(indexPattern, savedSearch, query) {
    super(indexPattern, savedSearch, query);
    (0, _defineProperty2.default)(this, "_type", _new_job.JOB_TYPE.CATEGORIZATION);
    (0, _defineProperty2.default)(this, "_createCountDetector", () => {});
    (0, _defineProperty2.default)(this, "_createRareDetector", () => {});
    (0, _defineProperty2.default)(this, "_examplesLoader", void 0);
    (0, _defineProperty2.default)(this, "_categoryFieldExamples", []);
    (0, _defineProperty2.default)(this, "_validationChecks", []);
    (0, _defineProperty2.default)(this, "_overallValidStatus", _categorization_job.CATEGORY_EXAMPLES_VALIDATION_STATUS.INVALID);
    (0, _defineProperty2.default)(this, "_detectorType", _mlAnomalyUtils.ML_JOB_AGGREGATION.COUNT);
    (0, _defineProperty2.default)(this, "_categorizationAnalyzer", {});
    (0, _defineProperty2.default)(this, "_defaultCategorizationAnalyzer", void 0);
    (0, _defineProperty2.default)(this, "_partitionFieldName", null);
    (0, _defineProperty2.default)(this, "_ccsVersionFailure", false);
    this.createdBy = _new_job.CREATED_BY_LABEL.CATEGORIZATION;
    this._examplesLoader = new _results_loader.CategorizationExamplesLoader(this, indexPattern, query);
    const {
      anomaly_detectors: anomalyDetectors
    } = (0, _ml_server_info.getNewJobDefaults)();
    this._defaultCategorizationAnalyzer = anomalyDetectors.categorization_analyzer || {};
  }
  setDefaultDetectorProperties(count, rare, eventRate) {
    if (count === null || rare === null || eventRate === null) {
      throw Error('event_rate field or count or rare aggregations missing');
    }
    this._createCountDetector = () => {
      this._createDetector(count, eventRate);
    };
    this._createRareDetector = () => {
      this._createDetector(rare, eventRate);
    };
  }
  _createDetector(agg, field) {
    const dtr = (0, _default_configs.createBasicDetector)(agg, field);
    dtr.by_field_name = _mlAnomalyUtils.mlCategory.id;

    // API requires if per_partition_categorization is enabled, add partition field to the detector
    if (this.perPartitionCategorization && this.categorizationPerPartitionField !== null) {
      dtr.partition_field_name = this.categorizationPerPartitionField;
    }
    this._addDetector(dtr, agg, _mlAnomalyUtils.mlCategory);
  }
  setDetectorType(type) {
    this._detectorType = type;
    this.removeAllDetectors();
    if (type === _mlAnomalyUtils.ML_JOB_AGGREGATION.COUNT) {
      this._createCountDetector();
      this.bucketSpan = _new_job.DEFAULT_BUCKET_SPAN;
    } else {
      this._createRareDetector();
      this.bucketSpan = _new_job.DEFAULT_RARE_BUCKET_SPAN;
      this.modelPlot = false;
    }
  }
  set categorizationFieldName(fieldName) {
    if (fieldName !== null) {
      this._job_config.analysis_config.categorization_field_name = fieldName;
      this.setDetectorType(this._detectorType);
      this.addInfluencer(_mlAnomalyUtils.mlCategory.id);
    } else {
      delete this._job_config.analysis_config.categorization_field_name;
      this._categoryFieldExamples = [];
      this._validationChecks = [];
      this._overallValidStatus = _categorization_job.CATEGORY_EXAMPLES_VALIDATION_STATUS.INVALID;
    }
  }
  get categorizationFieldName() {
    return this._job_config.analysis_config.categorization_field_name || null;
  }
  async loadCategorizationFieldExamples() {
    const {
      examples,
      sampleSize,
      overallValidStatus,
      validationChecks
    } = await this._examplesLoader.loadExamples();
    this._categoryFieldExamples = examples;
    this._validationChecks = validationChecks;
    this._overallValidStatus = overallValidStatus;
    this._ccsVersionFailure = this._checkCcsFailure(examples, overallValidStatus, validationChecks);
    if (this._ccsVersionFailure === true) {
      // if the data view contains a cross-cluster search, one of the clusters may
      // be on a version which doesn't support the fields API (e.g. 6.8)
      // and so the categorization examples endpoint will fail
      // if this is the case, we need to allow the user to progress in the wizard.
      this._overallValidStatus = _categorization_job.CATEGORY_EXAMPLES_VALIDATION_STATUS.VALID;
    }
    this._wizardInitialized$.next(true);
    return {
      examples,
      sampleSize,
      overallValidStatus,
      validationChecks,
      ccsVersionFailure: this._ccsVersionFailure
    };
  }

  // Check to see if the examples failed due to a cross-cluster search being used
  _checkCcsFailure(examples, status, checks) {
    var _checks$;
    return examples.length === 0 && status === _categorization_job.CATEGORY_EXAMPLES_VALIDATION_STATUS.INVALID && ((_checks$ = checks[0]) === null || _checks$ === void 0 ? void 0 : _checks$.id) === _categories.VALIDATION_RESULT.NO_EXAMPLES && (0, _index_utils.isCcsIndexPattern)(this.indexPatternTitle);
  }
  get categoryFieldExamples() {
    return this._categoryFieldExamples;
  }
  get validationChecks() {
    return this._validationChecks;
  }
  get overallValidStatus() {
    return this._overallValidStatus;
  }
  get selectedDetectorType() {
    return this._detectorType;
  }
  set categorizationAnalyzer(analyzer) {
    this._categorizationAnalyzer = analyzer;
    if ((0, _lodash.isEqual)(this._categorizationAnalyzer, this._defaultCategorizationAnalyzer)) {
      delete this._job_config.analysis_config.categorization_analyzer;
    } else {
      this._job_config.analysis_config.categorization_analyzer = analyzer;
    }
  }
  get categorizationAnalyzer() {
    return this._categorizationAnalyzer;
  }
  get categorizationPerPartitionField() {
    return this._partitionFieldName;
  }
  set categorizationPerPartitionField(fieldName) {
    if (fieldName === null) {
      this._detectors.forEach(detector => {
        delete detector.partition_field_name;
      });
      if (this._partitionFieldName !== null) this.removeInfluencer(this._partitionFieldName);
      this._partitionFieldName = null;
    } else {
      if (this._partitionFieldName !== fieldName) {
        // remove the previous field from list of influencers
        // and add the new one
        if (this._partitionFieldName !== null) this.removeInfluencer(this._partitionFieldName);
        this.addInfluencer(fieldName);
        this._partitionFieldName = fieldName;
        this._detectors.forEach(detector => {
          detector.partition_field_name = fieldName;
        });
      }
    }
  }

  // override the setter and getter for the per-partition toggle
  // so we can remove the partition field in the wizard when
  // per-partition categorization is disabled.
  get perPartitionCategorization() {
    var _this$_job_config$ana;
    return ((_this$_job_config$ana = this._job_config.analysis_config.per_partition_categorization) === null || _this$_job_config$ana === void 0 ? void 0 : _this$_job_config$ana.enabled) === true;
  }
  set perPartitionCategorization(enabled) {
    this._initPerPartitionCategorization();
    this._job_config.analysis_config.per_partition_categorization.enabled = enabled;
    if (enabled === false) {
      this.categorizationPerPartitionField = null;
    }
  }
  cloneFromExistingJob(job, datafeed) {
    this._overrideConfigs(job, datafeed);
    this.createdBy = _new_job.CREATED_BY_LABEL.CATEGORIZATION;
    const detectors = (0, _general.getRichDetectors)(job, datafeed, this.additionalFields, false);
    const dtr = detectors[0];
    if (dtr !== undefined && dtr.agg !== null && dtr.field !== null) {
      const detectorType = dtr.agg.id === _mlAnomalyUtils.ML_JOB_AGGREGATION.COUNT ? _mlAnomalyUtils.ML_JOB_AGGREGATION.COUNT : _mlAnomalyUtils.ML_JOB_AGGREGATION.RARE;
      const bs = job.analysis_config.bucket_span;
      this.setDetectorType(detectorType);
      if (dtr.partitionField !== null) {
        this.categorizationPerPartitionField = dtr.partitionField.id;
      }

      // set the bucketspan back to the original value
      // as setDetectorType applies a default
      this.bucketSpan = bs;
    }
  }
}
exports.CategorizationJobCreator = CategorizationJobCreator;