"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionJobIdLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../contexts/kibana");
var _locator = require("../../../../../../common/constants/locator");
var _job_group = require("../job_group");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

function isGroupIdLink(props) {
  return props.groupId !== undefined;
}
const AnomalyDetectionJobIdLink = props => {
  const mlLocator = (0, _kibana.useMlLocator)();
  const [href, setHref] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    let isCancelled = false;
    const generateLink = async () => {
      const pageState = {};
      if (isGroupIdLink(props)) {
        pageState.groupIds = [props.groupId];
      } else {
        pageState.jobId = props.id;
      }
      if (mlLocator) {
        const url = await mlLocator.getUrl({
          page: _locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE,
          // TODO: Fix this any.
          pageState: pageState
        });
        if (!isCancelled) {
          setHref(url);
        }
      }
    };
    generateLink();
    return () => {
      isCancelled = true;
    };
  }, [props, mlLocator]);
  if (isGroupIdLink(props)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      key: props.groupId,
      href: href
    }, /*#__PURE__*/_react.default.createElement(_job_group.JobGroup, {
      name: props.groupId
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      key: props.id,
      href: href,
      css: {
        overflow: 'hidden',
        'text-overflow': 'ellipsis'
      },
      title: props.id
    }, props.id);
  }
};
exports.AnomalyDetectionJobIdLink = AnomalyDetectionJobIdLink;