"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToDashboardControl = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddToDashboardControl = ({
  onClose,
  dashboardItems,
  isLoading,
  search,
  addToDashboardAndEditCallback,
  title,
  disabled,
  children
}) => {
  const columns = [{
    field: 'title',
    name: _i18n.i18n.translate('xpack.ml.explorer.dashboardsTable.titleColumnHeader', {
      defaultMessage: 'Title'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.ml.explorer.dashboardsTable.descriptionColumnHeader', {
      defaultMessage: 'Description'
    }),
    truncateText: true
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.ml.explorer.dashboardsTable.actionsHeader', {
      defaultMessage: 'Actions'
    }),
    width: '80px',
    actions: [{
      name: _i18n.i18n.translate('xpack.ml.explorer.dashboardsTable.editActionName', {
        defaultMessage: 'Add to dashboard'
      }),
      description: _i18n.i18n.translate('xpack.ml.explorer.dashboardsTable.editActionName', {
        defaultMessage: 'Add to dashboard'
      }),
      icon: 'documentEdit',
      type: 'icon',
      enabled: () => !disabled,
      onClick: async item => {
        await addToDashboardAndEditCallback(item);
      },
      'data-test-subj': 'mlEmbeddableAddAndEditDashboard'
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose.bind(null, undefined),
    "data-test-subj": "mlAddToDashboardModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, children, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.addToDashboard.selectDashboardsLabel",
      defaultMessage: "Select dashboards:"
    }),
    "data-test-subj": "mlDashboardSelectionContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    itemId: "id",
    isSelectable: false,
    hasActions: true,
    items: dashboardItems,
    loading: isLoading,
    columns: columns,
    search: search,
    pagination: true,
    sorting: true,
    "data-test-subj": `mlDashboardSelectionTable${isLoading ? ' loading' : ' loaded'}`,
    rowProps: item => ({
      'data-test-subj': `mlDashboardSelectionTableRow row-${item.id}`
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose.bind(null, undefined)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.addToDashboard.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))));
};
exports.AddToDashboardControl = AddToDashboardControl;