"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOutlierData = void 0;
var _react = require("react");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _mlDataGrid = require("@kbn/ml-data-grid");
var _data_loader = require("../../../../../datavisualizer/index_based/data_loader");
var _color_range_legend = require("../../../../../components/color_range_legend");
var _dependency_cache = require("../../../../../util/dependency_cache");
var _common = require("../../../../common");
var _common2 = require("./common");
var _use_exploration_data_grid = require("../exploration_results_table/use_exploration_data_grid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOutlierData = (indexPattern, jobConfig, searchQuery) => {
  var _jobConfig$dest$resul;
  const needsDestIndexFields = indexPattern !== undefined && indexPattern.title === (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.source.index[0]);
  const columns = (0, _react.useMemo)(() => {
    const newColumns = [];
    if (jobConfig !== undefined && indexPattern !== undefined) {
      const resultsField = jobConfig.dest.results_field;
      const {
        fieldTypes
      } = (0, _common.getIndexFields)(jobConfig, needsDestIndexFields);
      newColumns.push(...(0, _mlDataGrid.getDataGridSchemasFromFieldTypes)(fieldTypes, resultsField).sort((a, b) => (0, _mlDataFrameAnalyticsUtils.sortExplorationResultsFields)(a.id, b.id, jobConfig)));
    }
    return newColumns;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobConfig, indexPattern]);
  const dataGrid = (0, _use_exploration_data_grid.useExplorationDataGrid)(columns,
  // reduce default selected rows from 20 to 8 for performance reasons.
  8,
  // by default, hide feature-influence columns and the doc id copy
  d => !d.includes(`.${_mlDataFrameAnalyticsUtils.FEATURE_INFLUENCE}.`) && d !== _mlDataFrameAnalyticsUtils.ML__ID_COPY && d !== _mlDataFrameAnalyticsUtils.ML__INCREMENTAL_ID);

  // initialize sorting: reverse sort on outlier score column
  (0, _react.useEffect)(() => {
    if (jobConfig !== undefined) {
      dataGrid.setSortingColumns([{
        id: (0, _common2.getOutlierScoreFieldName)(jobConfig),
        direction: 'desc'
      }]);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobConfig && jobConfig.id]);

  // The pattern using `didCancel` allows us to abort out of date remote request.
  // We wrap `didCancel` in a object so we can mutate the value as it's being
  // passed on to `getIndexData`.
  (0, _react.useEffect)(() => {
    const options = {
      didCancel: false
    };
    (0, _common.getIndexData)(jobConfig, dataGrid, searchQuery, options);
    return () => {
      options.didCancel = true;
    };
    // custom comparison
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobConfig && jobConfig.id, dataGrid.pagination, searchQuery, dataGrid.sortingColumns]);
  const dataLoader = (0, _react.useMemo)(() => indexPattern !== undefined ? new _data_loader.DataLoader(indexPattern, (0, _dependency_cache.getToastNotifications)()) : undefined, [indexPattern]);
  const fetchColumnChartsData = async function () {
    try {
      if (jobConfig !== undefined && dataLoader !== undefined) {
        const columnChartsData = await dataLoader.loadFieldHistograms(columns.filter(cT => dataGrid.visibleColumns.includes(cT.id)).map(cT => ({
          fieldName: cT.id,
          type: (0, _mlDataGrid.getFieldType)(cT.schema)
        })), searchQuery);
        dataGrid.setColumnCharts(columnChartsData);
      }
    } catch (e) {
      (0, _mlDataGrid.showDataGridColumnChartErrorMessageToast)(e, (0, _dependency_cache.getToastNotifications)());
    }
  };
  (0, _react.useEffect)(() => {
    if (dataGrid.chartsVisible) {
      fetchColumnChartsData();
    }
    // custom comparison
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dataGrid.chartsVisible, jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.index,
  // Only trigger when search or the visible columns changes.
  // We're only interested in the visible columns but not their order, that's
  // why we sort for comparison (and copying it via spread to avoid sort in place).
  // eslint-disable-next-line react-hooks/exhaustive-deps
  JSON.stringify([searchQuery, [...dataGrid.visibleColumns].sort()])]);
  const colorRange = (0, _color_range_legend.useColorRange)(_color_range_legend.COLOR_RANGE.BLUE, _color_range_legend.COLOR_RANGE_SCALE.INFLUENCER, jobConfig !== undefined ? (0, _common2.getFeatureCount)(jobConfig.dest.results_field, dataGrid.tableItems) : 1);
  const renderCellValue = (0, _mlDataGrid.useRenderCellValue)(indexPattern, dataGrid.pagination, dataGrid.tableItems, (_jobConfig$dest$resul = jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.results_field) !== null && _jobConfig$dest$resul !== void 0 ? _jobConfig$dest$resul : _mlDataFrameAnalyticsUtils.DEFAULT_RESULTS_FIELD, (columnId, cellValue, fullItem, setCellProps) => {
    var _jobConfig$dest$resul2;
    const resultsField = (_jobConfig$dest$resul2 = jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.results_field) !== null && _jobConfig$dest$resul2 !== void 0 ? _jobConfig$dest$resul2 : '';
    let backgroundColor;
    const featureNames = fullItem[`${resultsField}.${_mlDataFrameAnalyticsUtils.FEATURE_INFLUENCE}`];

    // column with feature values get color coded by its corresponding influencer value
    if (Array.isArray(featureNames)) {
      const featureForColumn = featureNames.find(feature => columnId === feature.feature_name[0]);
      if (featureForColumn) {
        backgroundColor = colorRange(featureForColumn.influence[0]);
      }
    }

    // From EUI docs: Treated as React component allowing hooks, context, and other React concepts to be used.
    // This is the recommended use of setCellProps: https://github.com/elastic/eui/blob/main/src/components/datagrid/data_grid_types.ts#L521-L525
    // eslint-disable-next-line react-hooks/rules-of-hooks
    (0, _react.useEffect)(() => {
      if (backgroundColor) {
        setCellProps({
          style: {
            backgroundColor: String(backgroundColor)
          }
        });
      }
    }, [backgroundColor, setCellProps]);
  });
  return {
    ...dataGrid,
    renderCellValue
  };
};
exports.useOutlierData = useOutlierData;