"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConfusionMatrix = void 0;
var _react = require("react");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _new_job_capabilities_service_analytics = require("../../../../../services/new_job_capabilities/new_job_capabilities_service_analytics");
var _analytics = require("../../../../common/analytics");
var _common = require("../../../../common");
var _is_training_filter = require("./is_training_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEvalutionMetricsItems(evalMetrics) {
  var _evalMetrics$accuracy, _evalMetrics$recall;
  if (evalMetrics === undefined) return [];
  const accuracyMetrics = ((_evalMetrics$accuracy = evalMetrics.accuracy) === null || _evalMetrics$accuracy === void 0 ? void 0 : _evalMetrics$accuracy.classes) || [];
  const recallMetrics = ((_evalMetrics$recall = evalMetrics.recall) === null || _evalMetrics$recall === void 0 ? void 0 : _evalMetrics$recall.classes) || [];
  const metricsMap = accuracyMetrics.reduce((acc, accuracyMetric) => {
    acc[accuracyMetric.class_name] = {
      className: accuracyMetric.class_name,
      accuracy: accuracyMetric.value
    };
    return acc;
  }, {});
  recallMetrics.forEach(recallMetric => {
    if (metricsMap[recallMetric.class_name] !== undefined) {
      metricsMap[recallMetric.class_name] = {
        recall: recallMetric.value,
        ...metricsMap[recallMetric.class_name]
      };
    } else {
      metricsMap[recallMetric.class_name] = {
        className: recallMetric.class_name,
        recall: recallMetric.value
      };
    }
  });
  return Object.values(metricsMap);
}
const useConfusionMatrix = (jobConfig, searchQuery) => {
  const [confusionMatrixData, setConfusionMatrixData] = (0, _react.useState)([]);
  const [overallAccuracy, setOverallAccuracy] = (0, _react.useState)(null);
  const [avgRecall, setAvgRecall] = (0, _react.useState)(null);
  const [evaluationMetricsItems, setEvaluationMetricsItems] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [docsCount, setDocsCount] = (0, _react.useState)(null);
  const [error, setError] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    async function loadConfusionMatrixData() {
      setIsLoading(true);
      let requiresKeyword = false;
      const dependentVariable = (0, _mlDataFrameAnalyticsUtils.getDependentVar)(jobConfig.analysis);
      const resultsField = jobConfig.dest.results_field;
      const isTraining = (0, _is_training_filter.isTrainingFilter)(searchQuery, resultsField);
      try {
        requiresKeyword = _new_job_capabilities_service_analytics.newJobCapsServiceAnalytics.isKeywordAndTextType(dependentVariable);
      } catch (e) {
        // Additional error handling due to missing field type is handled by loadEvalData
        console.error('Unable to load new field types', e); // eslint-disable-line no-console
      }

      const evalData = await (0, _common.loadEvalData)({
        isTraining,
        index: jobConfig.dest.index,
        dependentVariable,
        resultsField,
        predictionFieldName: (0, _mlDataFrameAnalyticsUtils.getPredictionFieldName)(jobConfig.analysis),
        searchQuery,
        jobType: _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION,
        requiresKeyword
      });
      const docsCountResp = await (0, _common.loadDocsCount)({
        isTraining,
        searchQuery,
        resultsField,
        destIndex: jobConfig.dest.index
      });
      if (evalData.success === true && evalData.eval && (0, _analytics.isClassificationEvaluateResponse)(evalData.eval)) {
        var _evalData$eval, _evalData$eval$classi, _evalData$eval$classi2, _evalData$eval2, _evalData$eval2$class, _evalData$eval2$class2, _evalData$eval3, _evalData$eval3$class, _evalData$eval3$class2, _evalData$eval4;
        const confusionMatrix = (_evalData$eval = evalData.eval) === null || _evalData$eval === void 0 ? void 0 : (_evalData$eval$classi = _evalData$eval.classification) === null || _evalData$eval$classi === void 0 ? void 0 : (_evalData$eval$classi2 = _evalData$eval$classi.multiclass_confusion_matrix) === null || _evalData$eval$classi2 === void 0 ? void 0 : _evalData$eval$classi2.confusion_matrix;
        setError(null);
        setConfusionMatrixData(confusionMatrix || []);
        setAvgRecall(((_evalData$eval2 = evalData.eval) === null || _evalData$eval2 === void 0 ? void 0 : (_evalData$eval2$class = _evalData$eval2.classification) === null || _evalData$eval2$class === void 0 ? void 0 : (_evalData$eval2$class2 = _evalData$eval2$class.recall) === null || _evalData$eval2$class2 === void 0 ? void 0 : _evalData$eval2$class2.avg_recall) || null);
        setOverallAccuracy(((_evalData$eval3 = evalData.eval) === null || _evalData$eval3 === void 0 ? void 0 : (_evalData$eval3$class = _evalData$eval3.classification) === null || _evalData$eval3$class === void 0 ? void 0 : (_evalData$eval3$class2 = _evalData$eval3$class.accuracy) === null || _evalData$eval3$class2 === void 0 ? void 0 : _evalData$eval3$class2.overall_accuracy) || null);
        setEvaluationMetricsItems(getEvalutionMetricsItems((_evalData$eval4 = evalData.eval) === null || _evalData$eval4 === void 0 ? void 0 : _evalData$eval4.classification));
        setIsLoading(false);
      } else {
        setIsLoading(false);
        setConfusionMatrixData([]);
        setError(evalData.error);
      }
      if (docsCountResp.success === true) {
        setDocsCount(docsCountResp.docsCount);
      } else {
        setDocsCount(null);
      }
    }
    loadConfusionMatrixData();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify([jobConfig, searchQuery])]);
  return {
    avgRecall,
    confusionMatrixData,
    docsCount,
    error,
    isLoading,
    overallAccuracy,
    evaluationMetricsItems
  };
};
exports.useConfusionMatrix = useConfusionMatrix;