"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewResultsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../contexts/kibana");
var _locator = require("../../../../../../../common/constants/locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ViewResultsPanel = ({
  jobId,
  analysisType
}) => {
  const analyticsExplorationPageLink = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION,
    pageState: {
      jobId,
      analysisType
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    className: "dfAnalyticsCreationWizard__card",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "visTable"
    }),
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.viewResultsCardTitle', {
      defaultMessage: 'View Results'
    }),
    description: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.viewResultsCardDescription', {
      defaultMessage: 'View results for the analytics job.'
    }),
    href: analyticsExplorationPageLink,
    "data-test-subj": "analyticsWizardViewResultsCard"
  }));
};
exports.ViewResultsPanel = ViewResultsPanel;