"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurationStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _configuration_step_details = require("./configuration_step_details");
var _configuration_step_form = require("./configuration_step_form");
var _page = require("../../page");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigurationStep = ({
  actions,
  state,
  setCurrentStep,
  step,
  stepActivated,
  isClone
}) => {
  const showForm = step === _page.ANALYTICS_STEPS.CONFIGURATION;
  const showDetails = step !== _page.ANALYTICS_STEPS.CONFIGURATION && stepActivated === true;
  const dataTestSubj = `mlAnalyticsCreateJobWizardConfigurationStep${showForm ? ' active' : ''}${showDetails ? ' summary' : ''}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    className: "mlDataFrameAnalyticsCreateForm",
    "data-test-subj": dataTestSubj
  }, showForm && /*#__PURE__*/_react.default.createElement(_configuration_step_form.ConfigurationStepForm, {
    actions: actions,
    isClone: isClone,
    state: state,
    setCurrentStep: setCurrentStep
  }), showDetails && /*#__PURE__*/_react.default.createElement(_configuration_step_details.ConfigurationStepDetails, {
    setCurrentStep: setCurrentStep,
    state: state
  }));
};
exports.ConfigurationStep = ConfigurationStep;