"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteSpaceAwareItemCheckModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _kibana = require("../../contexts/kibana");
var _toast_notification_service = require("../../services/toast_notification_service");
var _managed_jobs_warning_callout = require("../../jobs/jobs_list/components/confirm_modals/managed_jobs_warning_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const shouldUnTagJobLabel = _i18n.i18n.translate('xpack.ml.deleteSpaceAwareItemCheckModal.shouldUnTagLabel.job', {
  defaultMessage: 'Remove job from current space'
});
const shouldUnTagModelLabel = _i18n.i18n.translate('xpack.ml.deleteSpaceAwareItemCheckModal.shouldUnTagLabel.model', {
  defaultMessage: 'Remove model from current space'
});
function getRespSummary(resp) {
  const itemsChecked = Object.keys(resp);
  // Default to first item's permissions
  const {
    canDelete,
    canRemoveFromSpace
  } = resp[itemsChecked[0]];
  let canTakeAnyAction = true;
  if (itemsChecked.length > 1) {
    // Check all jobs and make sure they have the same permissions - otherwise no action can be taken
    canTakeAnyAction = itemsChecked.every(id => resp[id].canDelete === canDelete && resp[id].canRemoveFromSpace === canRemoveFromSpace);
  }
  return {
    canDelete,
    canRemoveFromSpace,
    canTakeAnyAction
  };
}
function getModalContent(ids, mlSavedObjectType, respSummary, hasManagedJob) {
  const {
    canDelete,
    canRemoveFromSpace,
    canTakeAnyAction
  } = respSummary;
  if (canTakeAnyAction === false) {
    return {
      buttonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.buttonTextNoAction",
        defaultMessage: "Close"
      }),
      modalText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextNoAction",
        defaultMessage: "{ids} have different space permissions. ",
        values: {
          ids: ids.join(', ')
        }
      }), mlSavedObjectType === 'trained-model' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextNoAction.model",
        defaultMessage: "When you delete multiple models, they must have the same permissions. Deselect the models and try deleting each model individually."
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextNoAction.job",
        defaultMessage: "When you delete multiple jobs, they must have the same permissions. Deselect the jobs and try deleting each job individually."
      }))
    };
  }
  const noActionContent = {
    buttonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.deleteSpaceAwareItemCheckModal.buttonTextClose",
      defaultMessage: "Close"
    }),
    modalText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextClose",
      defaultMessage: "{ids} cannot be deleted and cannot be removed from the current space. ",
      values: {
        ids: ids.join(', ')
      }
    }), mlSavedObjectType === 'trained-model' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextClose.model",
      defaultMessage: "This model is assigned to the * space and you do not have access to all spaces."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextClose.job",
      defaultMessage: "This job is assigned to the * space and you do not have access to all spaces."
    }))
  };
  if (canDelete) {
    return {
      buttonText: mlSavedObjectType === 'trained-model' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.buttonTextCanDelete.model",
        defaultMessage: "Continue to delete {length, plural, one {# model} other {# models}}",
        values: {
          length: ids.length
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.buttonTextCanDelete.job",
        defaultMessage: "Continue to delete {length, plural, one {# job} other {# jobs}}",
        values: {
          length: ids.length
        }
      }),
      modalText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasManagedJob ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
        jobsCount: ids.length,
        action: _i18n.i18n.translate('xpack.ml.jobsList.deleteJobCheckModal.removeOrDeleteAction', {
          defaultMessage: 'removing or deleting'
        })
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextCanDelete",
        defaultMessage: "{ids} can be deleted.",
        values: {
          ids: ids.join(', ')
        }
      })))
    };
  } else if (canRemoveFromSpace) {
    return {
      buttonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.buttonTextCanUnTagConfirm",
        defaultMessage: "Remove from current space"
      }),
      modalText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasManagedJob ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
        jobsCount: ids.length,
        action: _i18n.i18n.translate('xpack.ml.jobsList.deleteJobCheckModal.removeAction', {
          defaultMessage: 'removing'
        })
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextCanUnTag",
        defaultMessage: "{ids} cannot be deleted but can be removed from the current space.",
        values: {
          ids: ids.join(', ')
        }
      })))
    };
  } else {
    return noActionContent;
  }
}
const DeleteSpaceAwareItemCheckModal = ({
  canDeleteCallback,
  onCloseCallback,
  refreshJobsCallback,
  mlSavedObjectType,
  ids,
  setDidUntag,
  hasManagedJob
}) => {
  const [buttonContent, setButtonContent] = (0, _react.useState)();
  const [modalContent, setModalContent] = (0, _react.useState)();
  const [hasUntagged, setHasUntagged] = (0, _react.useState)(false);
  const [isUntagging, setIsUntagging] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [itemCheckRespSummary, setItemCheckRespSummary] = (0, _react.useState)();
  const {
    savedObjects: {
      canDeleteMLSpaceAwareItems,
      removeItemFromCurrentSpace
    }
  } = (0, _kibana.useMlApiContext)();
  const {
    displayErrorToast,
    displaySuccessToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  (0, _react.useEffect)(() => {
    setIsLoading(true);
    // Do the spaces check and set the content for the modal and buttons depending on results
    canDeleteMLSpaceAwareItems(mlSavedObjectType, ids).then(resp => {
      const respSummary = getRespSummary(resp);
      const {
        canDelete,
        canRemoveFromSpace,
        canTakeAnyAction
      } = respSummary;
      if (canTakeAnyAction && canDelete && !canRemoveFromSpace) {
        // Go straight to delete flow if that's the only action available
        canDeleteCallback();
        return;
      }
      setItemCheckRespSummary(respSummary);
      const {
        buttonText,
        modalText
      } = getModalContent(ids, mlSavedObjectType, respSummary, hasManagedJob);
      setButtonContent(buttonText);
      setModalContent(modalText);
    });
    if (typeof setDidUntag === 'function') {
      setDidUntag(false);
    }
    setIsLoading(false);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [hasManagedJob]);
  const onUntagClick = async () => {
    setIsUntagging(true);
    const resp = await removeItemFromCurrentSpace(mlSavedObjectType, ids);
    setIsUntagging(false);
    if (typeof setDidUntag === 'function') {
      setDidUntag(true);
    }
    Object.entries(resp).forEach(([id, {
      success,
      error
    }]) => {
      if (success === false) {
        const title = _i18n.i18n.translate('xpack.ml.deleteSpaceAwareItemCheckModal.unTagErrorTitle', {
          defaultMessage: 'Error updating {id}',
          values: {
            id
          }
        });
        displayErrorToast(error, title);
      } else {
        setHasUntagged(true);
        const message = _i18n.i18n.translate('xpack.ml.deleteSpaceAwareItemCheckModal.unTagSuccessTitle', {
          defaultMessage: 'Successfully updated {id}',
          values: {
            id
          }
        });
        displaySuccessToast(message);
      }
    });
    // Close the modal
    onCloseCallback();
    if (typeof refreshJobsCallback === 'function') {
      refreshJobsCallback();
    }
  };
  const onClick = async () => {
    if (itemCheckRespSummary !== null && itemCheckRespSummary !== void 0 && itemCheckRespSummary.canTakeAnyAction && itemCheckRespSummary !== null && itemCheckRespSummary !== void 0 && itemCheckRespSummary.canDelete) {
      canDeleteCallback();
    } else {
      onCloseCallback();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onCloseCallback,
    "data-test-subj": "mlDeleteSpaceAwareItemCheckModalOverlay"
  }, isLoading === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  }))))), isLoading === false && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTitle",
    defaultMessage: "Checking space permissions"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, modalContent), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !hasUntagged && (itemCheckRespSummary === null || itemCheckRespSummary === void 0 ? void 0 : itemCheckRespSummary.canTakeAnyAction) && (itemCheckRespSummary === null || itemCheckRespSummary === void 0 ? void 0 : itemCheckRespSummary.canRemoveFromSpace) && (itemCheckRespSummary === null || itemCheckRespSummary === void 0 ? void 0 : itemCheckRespSummary.canDelete) && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: isUntagging,
    color: "primary",
    size: "s",
    onClick: onUntagClick
  }, mlSavedObjectType === 'trained-model' ? shouldUnTagModelLabel : shouldUnTagJobLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: itemCheckRespSummary !== null && itemCheckRespSummary !== void 0 && itemCheckRespSummary.canTakeAnyAction && itemCheckRespSummary !== null && itemCheckRespSummary !== void 0 && itemCheckRespSummary.canRemoveFromSpace && !(itemCheckRespSummary !== null && itemCheckRespSummary !== void 0 && itemCheckRespSummary.canDelete) ? onUntagClick : onClick,
    fill: true
  }, buttonContent))))));
};
exports.DeleteSpaceAwareItemCheckModal = DeleteSpaceAwareItemCheckModal;