"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDropDownOptions = getDropDownOptions;
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _anomaly_detection_jobs = require("../../../../../common/types/anomaly_detection_jobs");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDropDownOptions(isFirstRender, job, dataView) {
  if ((0, _anomaly_detection_jobs.isAnomalyDetectionJob)(job) && isFirstRender) {
    return (0, _utils.getQueryEntityFieldNames)(job);
  } else if (((0, _mlDataFrameAnalyticsUtils.isDataFrameAnalyticsConfigs)(job) || !isFirstRender) && dataView !== undefined) {
    return (0, _utils.getSupportedFieldNames)(job, dataView);
  }
  return [];
}