"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CheckboxShowCharts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _anomaly_explorer_context = require("../../../explorer/anomaly_explorer_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for a checkbox element to toggle charts display.
 */
const CheckboxShowCharts = () => {
  const {
    chartsStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const showCharts = (0, _useObservable.default)(chartsStateService.getShowCharts$(), chartsStateService.getShowCharts());
  const onChange = (0, _react.useCallback)(e => {
    chartsStateService.setShowCharts(e.target.checked);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const id = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: id,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.controls.checkboxShowCharts.showChartsCheckboxLabel",
      defaultMessage: "Show charts"
    }),
    checked: showCharts,
    onChange: onChange
  });
};
exports.CheckboxShowCharts = CheckboxShowCharts;