"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeIntervalControl = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _util = require("../application/jobs/new_job/common/job_validator/util");
var _common = require("../../common");
var _validators = require("../../common/util/validators");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimeIntervalControl = ({
  value,
  onChange,
  label,
  ...fieldTextProps
}) => {
  const validators = (0, _react.useMemo)(() => (0, _common.composeValidators)((0, _validators.timeIntervalInputValidator)()), []);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const validationErrors = (0, _react.useMemo)(() => validators(value), [value]);
  const isInvalid = !!value && !!validationErrors;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    isInvalid: isInvalid,
    error: (0, _util.invalidTimeIntervalMessage)(value !== null && value !== void 0 ? value : undefined)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, fieldTextProps, {
    placeholder: "15d, 6m",
    value: value !== null && value !== void 0 ? value : '',
    onChange: e => {
      onChange(e.target.value);
    },
    isInvalid: isInvalid
  })));
};
exports.TimeIntervalControl = TimeIntervalControl;