"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultTypeSelector = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultTypeSelector = /*#__PURE__*/_react.default.memo(({
  value: selectedResultType = [],
  onChange,
  availableOption
}) => {
  const resultTypeOptions = (0, _react.useMemo)(() => {
    return [{
      value: _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.BUCKET,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.bucketResultType.title",
        defaultMessage: "Bucket"
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.bucketResultType.description",
        defaultMessage: "How unusual was the job within the bucket of time?"
      })
    }, {
      value: _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.RECORD,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.recordResultType.title",
        defaultMessage: "Record"
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.recordResultType.description",
        defaultMessage: "What individual anomalies are present in a time range?"
      })
    }, {
      value: _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.INFLUENCER,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.influencerResultType.title",
        defaultMessage: "Influencer"
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.influencerResultType.description",
        defaultMessage: "What are the most unusual entities in a time range?"
      })
    }].filter(v => availableOption.includes(v.value));
  }, [availableOption]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.resultTypeSelector.formControlLabel",
      defaultMessage: "Result type"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, resultTypeOptions.map(({
    value,
    title,
    description
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: value
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      title: title,
      titleSize: 'xs',
      paddingSize: 's',
      description: /*#__PURE__*/_react.default.createElement("small", null, description),
      selectable: {
        onClick: () => {
          if (selectedResultType === value) {
            // don't allow de-select
            return;
          }
          onChange(value);
        },
        isSelected: value === selectedResultType
      },
      "data-test-subj": `mlAnomalyAlertResult_${value}${value === selectedResultType ? '_selected' : ''}`
    }));
  })));
});
exports.ResultTypeSelector = ResultTypeSelector;