"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGeoHashBucketAgg = exports.GEOHASH_GRID = void 0;
var _fieldTypes = require("@kbn/field-types");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GEOHASH_GRID = 'geohash_grid';
exports.GEOHASH_GRID = GEOHASH_GRID;
const getGeoHashBucketAgg = () => new _common.BucketAggType({
  name: GEOHASH_GRID,
  expressionName: '',
  title: GEOHASH_GRID,
  makeLabel: () => GEOHASH_GRID,
  params: [{
    name: 'field',
    type: 'field',
    filterFieldTypes: _fieldTypes.KBN_FIELD_TYPES.GEO_POINT
  }],
  getRequestAggs(agg) {
    return [];
  }
});
exports.getGeoHashBucketAgg = getGeoHashBucketAgg;