"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapsClient = void 0;
var _content_management = require("../../common/content_management");
var _kibana_services = require("../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const get = async id => {
  return (0, _kibana_services.getContentManagement)().client.get({
    contentTypeId: _content_management.CONTENT_ID,
    id
  });
};
const create = async ({
  data,
  options
}) => {
  const res = await (0, _kibana_services.getContentManagement)().client.create({
    contentTypeId: _content_management.CONTENT_ID,
    data,
    options
  });
  return res;
};
const update = async ({
  id,
  data,
  options
}) => {
  const res = await (0, _kibana_services.getContentManagement)().client.update({
    contentTypeId: _content_management.CONTENT_ID,
    id,
    data,
    options
  });
  return res;
};
const deleteMap = async id => {
  await (0, _kibana_services.getContentManagement)().client.delete({
    contentTypeId: _content_management.CONTENT_ID,
    id
  });
};
const search = async (query = {}, options) => {
  return (0, _kibana_services.getContentManagement)().client.search({
    contentTypeId: _content_management.CONTENT_ID,
    query,
    options
  });
};
const mapsClient = {
  get,
  create,
  update,
  delete: deleteMap,
  search
};
exports.mapsClient = mapsClient;