"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolsControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/constants");
var _geometry_filter_form = require("../../../components/draw_forms/geometry_filter_form/geometry_filter_form");
var _distance_filter_form = require("../../../components/draw_forms/distance_filter_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DRAW_SHAPE_LABEL = _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawShapeLabel', {
  defaultMessage: 'Draw shape to filter data'
});
const DRAW_BOUNDS_LABEL = _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawBoundsLabel', {
  defaultMessage: 'Draw bounds to filter data'
});
const DRAW_DISTANCE_LABEL = _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawDistanceLabel', {
  defaultMessage: 'Draw distance to filter data'
});
const DRAW_SHAPE_LABEL_SHORT = _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawShapeLabelShort', {
  defaultMessage: 'Draw shape'
});
const DRAW_BOUNDS_LABEL_SHORT = _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawBoundsLabelShort', {
  defaultMessage: 'Draw bounds'
});
const DRAW_DISTANCE_LABEL_SHORT = _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawDistanceLabelShort', {
  defaultMessage: 'Draw distance'
});
class ToolsControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
      if (this.props.filterModeActive) {
        this.props.cancelDraw();
      }
    });
    (0, _defineProperty2.default)(this, "_initiateShapeDraw", options => {
      this.props.initiateDraw({
        drawShape: _constants.DRAW_SHAPE.POLYGON,
        ...options
      });
      this._closePopover();
    });
    (0, _defineProperty2.default)(this, "_initiateBoundsDraw", options => {
      this.props.initiateDraw({
        drawShape: _constants.DRAW_SHAPE.BOUNDS,
        ...options
      });
      this._closePopover();
    });
    (0, _defineProperty2.default)(this, "_initiateDistanceDraw", options => {
      this.props.initiateDraw({
        drawShape: _constants.DRAW_SHAPE.DISTANCE,
        ...options
      });
      this._closePopover();
    });
  }
  _getDrawPanels() {
    const tools = [{
      name: DRAW_SHAPE_LABEL,
      panel: 1
    }, {
      name: DRAW_BOUNDS_LABEL,
      panel: 2
    }, {
      name: DRAW_DISTANCE_LABEL,
      panel: 3
    }];
    return [{
      id: 0,
      title: _i18n.i18n.translate('xpack.maps.toolbarOverlay.tools.toolbarTitle', {
        defaultMessage: 'Tools'
      }),
      items: tools
    }, {
      id: 1,
      title: DRAW_SHAPE_LABEL_SHORT,
      content: /*#__PURE__*/_react.default.createElement(_geometry_filter_form.GeometryFilterForm, {
        className: "mapDrawControl__geometryFilterForm",
        buttonLabel: DRAW_SHAPE_LABEL_SHORT,
        getFilterActions: this.props.getFilterActions,
        getActionContext: this.props.getActionContext,
        intitialGeometryLabel: _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawShape.initialGeometryLabel', {
          defaultMessage: 'shape'
        }),
        onSubmit: this._initiateShapeDraw
      })
    }, {
      id: 2,
      title: DRAW_BOUNDS_LABEL_SHORT,
      content: /*#__PURE__*/_react.default.createElement(_geometry_filter_form.GeometryFilterForm, {
        className: "mapDrawControl__geometryFilterForm",
        buttonLabel: DRAW_BOUNDS_LABEL_SHORT,
        getFilterActions: this.props.getFilterActions,
        getActionContext: this.props.getActionContext,
        intitialGeometryLabel: _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawBounds.initialGeometryLabel', {
          defaultMessage: 'bounds'
        }),
        onSubmit: this._initiateBoundsDraw
      })
    }, {
      id: 3,
      title: DRAW_DISTANCE_LABEL_SHORT,
      content: /*#__PURE__*/_react.default.createElement(_distance_filter_form.DistanceFilterForm, {
        className: "mapDrawControl__geometryFilterForm",
        buttonLabel: DRAW_DISTANCE_LABEL_SHORT,
        getFilterActions: this.props.getFilterActions,
        getActionContext: this.props.getActionContext,
        onSubmit: this._initiateDistanceDraw
      })
    }];
  }
  _renderToolsButton() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "none",
      className: "mapToolbarOverlay__button"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      className: "mapToolbarOverlay__buttonIcon-empty",
      size: "s",
      color: "text",
      iconType: "wrench",
      onClick: this._togglePopover,
      "aria-label": _i18n.i18n.translate('xpack.maps.toolbarOverlay.toolsControlTitle', {
        defaultMessage: 'Tools'
      }),
      title: _i18n.i18n.translate('xpack.maps.toolbarOverlay.toolsControlTitle', {
        defaultMessage: 'Tools'
      }),
      isDisabled: this.props.disableToolsControl
    }));
  }
  render() {
    const toolsPopoverButton = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "toolsControlPopover",
      button: this._renderToolsButton(),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      panelPaddingSize: "none",
      anchorPosition: "leftUp",
      "data-test-subj": "mapToolsControlPopover"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: 0,
      panels: this._getDrawPanels()
    }));
    if (!this.props.filterModeActive) {
      return toolsPopoverButton;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, toolsPopoverButton), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      onClick: this.props.cancelDraw
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.tooltip.toolsControl.cancelDrawButtonLabel",
      defaultMessage: "Cancel"
    }))));
  }
}
exports.ToolsControl = ToolsControl;