"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecimalDegreesForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DecimalDegreesForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      lat: this.props.center.lat,
      lon: this.props.center.lon,
      zoom: this.props.zoom
    });
    (0, _defineProperty2.default)(this, "_onLatChange", evt => {
      const sanitizedValue = parseFloat(evt.target.value);
      this.setState({
        lat: isNaN(sanitizedValue) ? '' : sanitizedValue
      });
    });
    (0, _defineProperty2.default)(this, "_onLonChange", evt => {
      const sanitizedValue = parseFloat(evt.target.value);
      this.setState({
        lon: isNaN(sanitizedValue) ? '' : sanitizedValue
      });
    });
    (0, _defineProperty2.default)(this, "_onZoomChange", evt => {
      const sanitizedValue = parseFloat(evt.target.value);
      this.setState({
        zoom: isNaN(sanitizedValue) ? '' : sanitizedValue
      });
    });
    (0, _defineProperty2.default)(this, "_onSubmit", () => {
      const {
        lat,
        lon,
        zoom
      } = this.state;
      this.props.onSubmit(lat, lon, zoom);
    });
  }
  render() {
    const {
      isInvalid: isLatInvalid,
      error: latError
    } = (0, _utils.withinRange)(this.state.lat, -90, 90);
    const {
      isInvalid: isLonInvalid,
      error: lonError
    } = (0, _utils.withinRange)(this.state.lon, -180, 180);
    const {
      isInvalid: isZoomInvalid,
      error: zoomError
    } = (0, _utils.withinRange)(this.state.zoom, this.props.settings.minZoom, this.props.settings.maxZoom);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.latitudeLabel', {
        defaultMessage: 'Latitude'
      }),
      isInvalid: isLatInvalid,
      error: latError,
      display: "columnCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      value: this.state.lat,
      onChange: this._onLatChange,
      isInvalid: isLatInvalid,
      "data-test-subj": "latitudeInput"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.longitudeLabel', {
        defaultMessage: 'Longitude'
      }),
      isInvalid: isLonInvalid,
      error: lonError,
      display: "columnCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      value: this.state.lon,
      onChange: this._onLonChange,
      isInvalid: isLonInvalid,
      "data-test-subj": "longitudeInput"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.zoomLabel', {
        defaultMessage: 'Zoom'
      }),
      isInvalid: isZoomInvalid,
      error: zoomError,
      display: "columnCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      value: this.state.zoom,
      onChange: this._onZoomChange,
      isInvalid: isZoomInvalid,
      "data-test-subj": "zoomInput"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "right"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      disabled: isLatInvalid || isLonInvalid || isZoomInvalid,
      onClick: this._onSubmit,
      "data-test-subj": "submitViewButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.setViewControl.submitButtonLabel",
      defaultMessage: "Go"
    }))));
  }
}
exports.DecimalDegreesForm = DecimalDegreesForm;