"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipSelector = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _add_tooltip_field_popover = require("./add_tooltip_field_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO import reorder from EUI once its exposed as service
// https://github.com/elastic/eui/issues/2372
const reorder = (list, startIndex, endIndex) => {
  const result = Array.from(list);
  const [removed] = result.splice(startIndex, 1);
  result.splice(endIndex, 0, removed);
  return result;
};
async function getFieldProps(field) {
  return {
    label: await field.getLabel(),
    type: await field.getDataType(),
    name: field.getName()
  };
}
class TooltipSelector extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", void 0);
    (0, _defineProperty2.default)(this, "_previousFields", void 0);
    (0, _defineProperty2.default)(this, "_previousSelectedTooltips", void 0);
    (0, _defineProperty2.default)(this, "state", {
      fieldProps: [],
      selectedFieldProps: []
    });
    (0, _defineProperty2.default)(this, "_getPropertyLabel", propertyName => {
      if (!this.state.fieldProps.length) {
        return propertyName;
      }
      const prop = this.state.fieldProps.find(field => {
        return field.name === propertyName;
      });

      // @ts-expect-error 4.3.5 upgrade
      return prop ? prop.label : propertyName;
    });
    (0, _defineProperty2.default)(this, "_onAdd", properties => {
      if (!this.props.tooltipFields) {
        this.props.onChange([...properties]);
      } else {
        const existingProperties = this._getTooltipFieldNames();
        this.props.onChange([...existingProperties, ...properties]);
      }
    });
    (0, _defineProperty2.default)(this, "_removeProperty", index => {
      if (!this.props.tooltipFields) {
        this.props.onChange([]);
      } else {
        const tooltipProperties = this._getTooltipFieldNames();
        tooltipProperties.splice(index, 1);
        this.props.onChange(tooltipProperties);
      }
    });
    (0, _defineProperty2.default)(this, "_onDragEnd", ({
      source,
      destination
    }) => {
      // Dragging item out of EuiDroppable results in destination of null
      if (!destination) {
        return;
      }
      this.props.onChange(reorder(this._getTooltipFieldNames(), source.index, destination.index));
    });
    this._isMounted = false;
    this._previousFields = null;
    this._previousSelectedTooltips = null;
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadFieldProps();
    this._loadTooltipFieldProps();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidUpdate() {
    this._loadTooltipFieldProps();
    this._loadFieldProps();
  }
  async _loadTooltipFieldProps() {
    if (!this.props.tooltipFields || this.props.tooltipFields === this._previousSelectedTooltips) {
      return;
    }
    this._previousSelectedTooltips = this.props.tooltipFields;
    const promises = this.props.tooltipFields.map(getFieldProps);
    const selectedFieldProps = await Promise.all(promises);
    if (this._isMounted) {
      this.setState({
        selectedFieldProps
      });
    }
  }
  async _loadFieldProps() {
    if (!this.props.fields || this.props.fields === this._previousFields) {
      return;
    }
    this._previousFields = this.props.fields;
    const promises = this.props.fields.map(getFieldProps);
    const fieldProps = await Promise.all(promises);
    if (this._isMounted) {
      this.setState({
        fieldProps
      });
    }
  }
  _getTooltipFieldNames() {
    return this.props.tooltipFields ? this.props.tooltipFields.map(field => field.getName()) : [];
  }
  _renderProperties() {
    if (!this.state.selectedFieldProps.length) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        textAlign: "center"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.tooltipSelector.emptyState.description",
        defaultMessage: "Add a tooltip field to create filters from field values."
      }))));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
      onDragEnd: this._onDragEnd
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
      droppableId: "mapLayerTOC",
      spacing: "none"
    }, (droppableProvided, snapshot) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this.state.selectedFieldProps.map((field, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
      spacing: "none",
      key: field.name,
      index: idx,
      draggableId: field.name,
      customDragHandle: true,
      disableInteractiveElementBlocking: true // Allows button to be drag handle
    }, (provided, state) => /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('mapTooltipSelector__propertyRow', {
        'mapTooltipSelector__propertyRow-isDragging': state.isDragging,
        'mapTooltipSelector__propertyRow-isDraggingOver': snapshot.isDraggingOver
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      className: "mapTooltipSelector__propertyContent",
      size: "s"
    }, this._getPropertyLabel(field.name)), /*#__PURE__*/_react.default.createElement("div", {
      className: "mapTooltipSelector__propertyIcons"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      color: "danger",
      onClick: this._removeProperty.bind(null, idx),
      title: _i18n.i18n.translate('xpack.maps.tooltipSelector.trashButtonTitle', {
        defaultMessage: 'Remove property'
      }),
      "aria-label": _i18n.i18n.translate('xpack.maps.tooltipSelector.trashButtonAriaLabel', {
        defaultMessage: 'Remove property'
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
      className: "mapTooltipSelector__grab",
      iconType: "grab",
      color: "text",
      title: _i18n.i18n.translate('xpack.maps.tooltipSelector.grabButtonTitle', {
        defaultMessage: 'Reorder property'
      }),
      "aria-label": _i18n.i18n.translate('xpack.maps.tooltipSelector.grabButtonAriaLabel', {
        defaultMessage: 'Reorder property'
      })
    }, provided.dragHandleProps)))))))));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", null, this._renderProperties(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "center"
    }, /*#__PURE__*/_react.default.createElement(_add_tooltip_field_popover.AddTooltipFieldPopover, {
      onAdd: this._onAdd,
      fields: this.state.fieldProps,
      selectedFields: this.state.selectedFieldProps
    })));
  }
}
exports.TooltipSelector = TooltipSelector;