"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _trigger_utils = require("../trigger_actions/trigger_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ActionSelect extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      actions: []
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadActions();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadActions() {
    if (!this.props.getFilterActions || !this.props.getActionContext) {
      return;
    }
    const actions = await this.props.getFilterActions();
    if (this._isMounted) {
      this.setState({
        actions: actions.filter(action => !(0, _trigger_utils.isUrlDrilldown)(action))
      });
    }
  }
  render() {
    if (this.state.actions.length === 0 || !this.props.getActionContext) {
      return null;
    }
    if (this.state.actions.length === 1 && this.props.value === this.state.actions[0].id) {
      return null;
    }
    const actionContext = this.props.getActionContext();
    const options = this.state.actions.map(action => {
      const iconType = action.getIconType(actionContext);
      return {
        value: action.id,
        inputDisplay: /*#__PURE__*/_react.default.createElement("div", null, iconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          className: "mapActionSelectIcon",
          type: iconType
        }) : null, action.getDisplayName(actionContext))
      };
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.actionSelect.label', {
        defaultMessage: 'Action'
      }),
      display: "rowCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      compressed: true,
      options: options,
      valueOfSelected: this.props.value ? this.props.value : '',
      onChange: this.props.onChange
    }));
  }
}
exports.ActionSelect = ActionSelect;