"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ES_MVT_META_LAYER_NAME = exports.ES_MVT_HITS_TOTAL_VALUE = exports.ES_MVT_HITS_TOTAL_RELATION = void 0;
exports.getAggRange = getAggRange;
exports.getAggsMeta = getAggsMeta;
exports.getHitsMeta = getHitsMeta;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Elasticsearch vector tile API returns "meta" layer containing a single metadata feature for each tile request
// This file contains utility methods for pulling values out of metadata features
// Placing logic in a single file to provide a centrialize location and avoid scattering logic throughout plugin

const ES_MVT_META_LAYER_NAME = 'meta';
exports.ES_MVT_META_LAYER_NAME = ES_MVT_META_LAYER_NAME;
const ES_MVT_HITS_TOTAL_RELATION = 'hits.total.relation';
exports.ES_MVT_HITS_TOTAL_RELATION = ES_MVT_HITS_TOTAL_RELATION;
const ES_MVT_HITS_TOTAL_VALUE = 'hits.total.value';
exports.ES_MVT_HITS_TOTAL_VALUE = ES_MVT_HITS_TOTAL_VALUE;
function getAggsMeta(metaFeatures) {
  let docCount = 0;
  metaFeatures.forEach(metaFeature => {
    const count = metaFeature.properties ? metaFeature.properties['aggregations._count.sum'] : 0;
    if (count > 0) {
      docCount += count;
    }
  });
  return {
    docCount
  };
}
function getHitsMeta(metaFeatures, maxResultWindow) {
  let totalFeaturesCount = 0;
  let tilesWithFeatures = 0;
  let tilesWithTrimmedResults = 0;
  metaFeatures.forEach(metaFeature => {
    var _metaFeature$properti, _metaFeature$properti2;
    const count = metaFeature.properties ? metaFeature.properties[ES_MVT_HITS_TOTAL_VALUE] : 0;
    if (count > 0) {
      totalFeaturesCount += count;
      tilesWithFeatures++;
    }
    if ((metaFeature === null || metaFeature === void 0 ? void 0 : (_metaFeature$properti = metaFeature.properties) === null || _metaFeature$properti === void 0 ? void 0 : _metaFeature$properti[ES_MVT_HITS_TOTAL_RELATION]) === 'gte' && (metaFeature === null || metaFeature === void 0 ? void 0 : (_metaFeature$properti2 = metaFeature.properties) === null || _metaFeature$properti2 === void 0 ? void 0 : _metaFeature$properti2[ES_MVT_HITS_TOTAL_VALUE]) >= maxResultWindow + 1) {
      tilesWithTrimmedResults++;
    }
  });
  return {
    totalFeaturesCount,
    tilesWithFeatures,
    tilesWithTrimmedResults
  };
}
function getAggRange(metaFeature, subAggName) {
  const minField = `aggregations.${subAggName}.min`;
  const maxField = `aggregations.${subAggName}.max`;
  return metaFeature.properties && typeof metaFeature.properties[minField] === 'number' && typeof metaFeature.properties[maxField] === 'number' ? {
    min: metaFeature.properties[minField],
    max: metaFeature.properties[maxField]
  } : null;
}