"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconPreview = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mapboxGl = require("@kbn/mapbox-gl");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _symbol_utils = require("../../symbol_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IconPreview extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_checker", void 0);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_containerRef", null);
    (0, _defineProperty2.default)(this, "state", {
      map: null,
      iconColor: '#E7664C'
    });
    (0, _defineProperty2.default)(this, "_setIconColor", iconColor => {
      this.setState({
        iconColor
      }, () => {
        this._syncPaintPropertiesToMap();
      });
    });
    (0, _defineProperty2.default)(this, "_setContainerRef", element => {
      this._containerRef = element;
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._initializeMap();
  }
  componentDidUpdate(prevProps) {
    if (this.props.svg !== prevProps.svg || this.props.cutoff !== prevProps.cutoff || this.props.radius !== prevProps.radius) {
      this._syncImageToMap();
    }
  }
  componentWillUnmount() {
    this._isMounted = false;
    if (this._checker) {
      this._checker.destroy();
    }
    if (this.state.map) {
      this.state.map.remove();
      this.state.map = null;
    }
  }
  async _syncImageToMap() {
    if (this._isMounted && this.state.map) {
      const map = this.state.map;
      const {
        svg,
        cutoff,
        radius,
        isSvgInvalid
      } = this.props;
      if (!svg || isSvgInvalid) {
        map.setLayoutProperty('icon-layer', 'visibility', 'none');
        return;
      }
      const imageData = await (0, _symbol_utils.createSdfIcon)({
        svg,
        cutoff,
        radius
      });
      if (imageData) {
        if (map.hasImage(IconPreview.iconId)) {
          map.updateImage(IconPreview.iconId, imageData);
        } else {
          map.addImage(IconPreview.iconId, imageData, {
            sdf: true,
            pixelRatio: _symbol_utils.CUSTOM_ICON_PIXEL_RATIO
          });
        }
      }
      map.setLayoutProperty('icon-layer', 'icon-image', IconPreview.iconId);
      map.setLayoutProperty('icon-layer', 'icon-size', 6);
      map.setLayoutProperty('icon-layer', 'visibility', 'visible');
      this._syncPaintPropertiesToMap();
    }
  }
  _syncPaintPropertiesToMap() {
    const {
      map,
      iconColor
    } = this.state;
    if (!map) return;
    map.setPaintProperty('icon-layer', 'icon-halo-color', '#000000');
    map.setPaintProperty('icon-layer', 'icon-halo-width', 1);
    map.setPaintProperty('icon-layer', 'icon-color', iconColor);
    map.setLayoutProperty('icon-layer', 'icon-size', 12);
  }
  _initResizerChecker() {
    this._checker = new _public.ResizeChecker(this._containerRef);
    this._checker.on('resize', () => {
      if (this.state.map) {
        this.state.map.resize();
      }
    });
  }
  _createMapInstance() {
    const map = new _mapboxGl.maplibregl.Map({
      container: this._containerRef,
      interactive: false,
      center: [0, 0],
      zoom: 2,
      style: {
        version: 8,
        name: 'Empty',
        sources: {},
        layers: [{
          id: 'background',
          type: 'background',
          paint: {
            'background-color': 'rgba(0,0,0,0)'
          }
        }]
      }
    });
    map.on('load', () => {
      map.addLayer({
        id: 'icon-layer',
        type: 'symbol',
        source: {
          type: 'geojson',
          data: {
            type: 'Feature',
            geometry: {
              type: 'Point',
              coordinates: [0, 0]
            },
            properties: {}
          }
        }
      });
      this._syncImageToMap();
    });
    return map;
  }
  _initializeMap() {
    const map = this._createMapInstance();
    this.setState({
      map
    }, () => {
      this._initResizerChecker();
    });
  }
  render() {
    const iconColor = this.state.iconColor;
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      hasBorder: true,
      hasShadow: false,
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.maps.customIconModal.elementPreviewTooltip', {
        defaultMessage: 'Dynamic styling requires rendering SVG icons using a signed distance function. As a result, sharp corners and intricate details may not render correctly. You may be able to tweak the Alpha threshold and Radius for better results.'
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.maps.customIconModal.elementPreviewTitle', {
      defaultMessage: 'Render preview'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "subdued",
      type: "questionInCircle"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      hasShadow: false
    }, /*#__PURE__*/_react.default.createElement("div", {
      id: "mapsCustomIconPreview__mapContainer",
      ref: this._setContainerRef,
      "data-test-subj": "mapsCustomIconPreview",
      className: "mapsCustomIconPreview__mapContainer"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: "Preview color"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
      onChange: this._setIconColor,
      color: iconColor
    })))));
  }
}
exports.IconPreview = IconPreview;
(0, _defineProperty2.default)(IconPreview, "iconId", `iconPreview`);