"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelect = FieldSelect;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactField = require("@kbn/react-field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function renderOption(option, searchValue, contentClassName) {
  const fieldIcon = option.value ? /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
    type: option.value.type,
    fill: "none"
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: contentClassName,
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: null
  }, fieldIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: searchValue
  }, option.label)));
}
function groupFieldsByOrigin(fields) {
  const fieldsByOriginMap = new Map();
  fields.forEach(field => {
    if (fieldsByOriginMap.has(field.origin)) {
      const fieldsList = fieldsByOriginMap.get(field.origin);
      fieldsList.push(field);
      fieldsByOriginMap.set(field.origin, fieldsList);
    } else {
      fieldsByOriginMap.set(field.origin, [field]);
    }
  });
  function fieldsListToOptions(fieldsList) {
    return fieldsList.map(field => {
      return {
        value: field,
        label: field.label,
        disabled: field.isUnsupported,
        title: field.unsupportedMsg
      };
    }).sort((a, b) => {
      return a.label.toLowerCase().localeCompare(b.label.toLowerCase());
    });
  }
  if (fieldsByOriginMap.size === 1) {
    // do not show origin group if all fields are from same origin
    const onlyOriginKey = fieldsByOriginMap.keys().next().value;
    const fieldsList = fieldsByOriginMap.get(onlyOriginKey);
    return fieldsListToOptions(fieldsList);
  }
  const optionGroups = [];
  fieldsByOriginMap.forEach((fieldsList, fieldOrigin) => {
    optionGroups.push({
      label: _i18n.i18n.translate('xpack.maps.style.fieldSelect.OriginLabel', {
        defaultMessage: 'Fields from {fieldOrigin}',
        values: {
          fieldOrigin
        }
      }),
      options: fieldsListToOptions(fieldsList)
    });
  });
  optionGroups.sort((a, b) => {
    return a.label.toLowerCase().localeCompare(b.label.toLowerCase());
  });
  return optionGroups;
}
function FieldSelect({
  fields,
  selectedFieldName,
  onChange,
  styleName,
  ...rest
}) {
  const onFieldChange = selectedFields => {
    onChange({
      field: selectedFields.length > 0 && selectedFields[0].value ? selectedFields[0].value : null
    });
  };
  let selectedOption;
  if (selectedFieldName) {
    const field = fields.find(f => {
      return f.name === selectedFieldName;
    });
    if (field) {
      selectedOption = {
        value: field,
        label: field.label
      };
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    selectedOptions: selectedOption ? [selectedOption] : [],
    options: groupFieldsByOrigin(fields),
    onChange: onFieldChange,
    singleSelection: {
      asPlainText: true
    },
    isClearable: false,
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.maps.styles.vector.selectFieldPlaceholder', {
      defaultMessage: 'Select a field'
    }),
    renderOption: renderOption,
    "data-test-subj": `styleFieldSelect_${styleName}`
  }, rest));
}