"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableSource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _uuid = require("uuid");
var _constants = require("../../../../../common/constants");
var _vector_source = require("../../vector_source");
var _inline_field = require("../../../fields/inline_field");
var _tooltip_property = require("../../../tooltips/tooltip_property");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TableSource extends _vector_source.AbstractVectorSource {
  static createDescriptor(descriptor) {
    return {
      type: _constants.SOURCE_TYPES.TABLE_SOURCE,
      __rows: descriptor.__rows || [],
      __columns: descriptor.__columns || [],
      term: descriptor.term || '',
      id: descriptor.id || (0, _uuid.v4)()
    };
  }
  constructor(descriptor) {
    const sourceDescriptor = TableSource.createDescriptor(descriptor);
    super(sourceDescriptor);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = sourceDescriptor;
  }
  async getDisplayName() {
    // no need to localize. this is never rendered.
    return `table source ${(0, _uuid.v4)()}`;
  }
  getSyncMeta() {
    return null;
  }
  async getPropertiesMap(requestMeta, leftSourceName, leftFieldName, registerCancelCallback) {
    const propertiesMap = new Map();
    const fieldNames = await this.getFieldNames();
    for (let i = 0; i < this._descriptor.__rows.length; i++) {
      const row = this._descriptor.__rows[i];
      let propKey;
      const props = {};
      for (const key in row) {
        if (row.hasOwnProperty(key)) {
          if (key === this._descriptor.term && row[key]) {
            propKey = row[key];
          }
          if (fieldNames.indexOf(key) >= 0 && key !== this._descriptor.term) {
            props[key] = row[key];
          }
        }
      }
      if (propKey && !propertiesMap.has(propKey.toString())) {
        // If propKey is not a primary key in the table, this will favor the first match
        propertiesMap.set(propKey.toString(), props);
      }
    }
    return propertiesMap;
  }
  getTermField() {
    const column = this._descriptor.__columns.find(c => {
      return c.name === this._descriptor.term;
    });
    if (!column) {
      throw new Error(`Cannot find column for ${this._descriptor.term} in ${JSON.stringify(this._descriptor.__columns)}`);
    }
    return new _inline_field.InlineField({
      fieldName: column.name,
      label: column.label,
      source: this,
      origin: _constants.FIELD_ORIGIN.JOIN,
      dataType: column.type
    });
  }
  getWhereQuery() {
    return undefined;
  }
  hasCompleteConfig() {
    return true;
  }
  getId() {
    return this._descriptor.id;
  }
  getRightFields() {
    return this._descriptor.__columns.map(column => {
      return new _inline_field.InlineField({
        fieldName: column.name,
        label: column.label,
        source: this,
        origin: _constants.FIELD_ORIGIN.JOIN,
        dataType: column.type
      });
    });
  }
  getFieldNames() {
    return this._descriptor.__columns.map(column => {
      return column.name;
    });
  }
  hasTooltipProperties() {
    return false;
  }
  createField({
    fieldName
  }) {
    const field = this.getFieldByName(fieldName);
    if (!field) {
      throw new Error(`Cannot find field for ${fieldName}`);
    }
    return field;
  }
  async getBoundsForFilters(boundsFilters, registerCancelCallback) {
    return null;
  }
  getFieldByName(fieldName) {
    const column = this._descriptor.__columns.find(c => {
      return c.name === fieldName;
    });
    if (!column) {
      return null;
    }
    return new _inline_field.InlineField({
      fieldName: column.name,
      label: column.label,
      source: this,
      origin: _constants.FIELD_ORIGIN.JOIN,
      dataType: column.type
    });
  }
  getFields() {
    throw new Error('must implement');
  }

  // The below is the IVectorSource interface.
  // Could be useful to implement, e.g. to preview raw csv data
  async getGeoJsonWithMeta(layerName, requestMeta, registerCancelCallback, isRequestStillActive) {
    throw new Error('TableSource cannot return GeoJson');
  }
  async getLeftJoinFields() {
    throw new Error('TableSource cannot be used as a left-layer in a term join');
  }
  getSourceStatus(sourceDataRequest) {
    throw new Error('must add tooltip content');
  }
  async getSupportedShapeTypes() {
    return [];
  }
  isBoundsAware() {
    return false;
  }
  async getTooltipProperties(properties) {
    const tooltipProperties = [];
    for (const key in properties) {
      if (properties.hasOwnProperty(key)) {
        const field = this.getFieldByName(key);
        if (field) {
          tooltipProperties.push(new _tooltip_property.TooltipProperty(key, await field.getLabel(), properties[key]));
        }
      }
    }
    return tooltipProperties;
  }
}
exports.TableSource = TableSource;
(0, _defineProperty2.default)(TableSource, "type", _constants.SOURCE_TYPES.TABLE_SOURCE);