"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToGeoJson = convertToGeoJson;
var _lodash = _interopRequireDefault(require("lodash"));
var _elasticsearch_util = require("../../../../common/elasticsearch_util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KEYS_TO_IGNORE = ['key', 'path'];
function convertToGeoJson(esResponse, entitySplitFieldName) {
  const features = [];
  let numTrimmedTracks = 0;
  const buckets = _lodash.default.get(esResponse, 'aggregations.tracks.buckets', {});
  const entityKeys = Object.keys(buckets);
  for (let i = 0; i < entityKeys.length; i++) {
    const entityKey = entityKeys[i];
    const bucket = buckets[entityKey];
    const feature = bucket.path;
    if (!feature.properties.complete) {
      numTrimmedTracks++;
    }
    feature.id = entityKey;
    feature.properties = {
      [entitySplitFieldName]: entityKey,
      ...feature.properties,
      ...(0, _elasticsearch_util.extractPropertiesFromBucket)(bucket, KEYS_TO_IGNORE)
    };
    features.push(feature);
  }
  return {
    featureCollection: {
      type: 'FeatureCollection',
      features
    },
    numTrimmedTracks
  };
}