"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _i18n_getters = require("../../../../common/i18n_getters");
var _constants = require("../../../../common/constants");
var _metrics_editor = require("../../../components/metrics_editor");
var _kibana_services = require("../../../kibana_services");
var _resolution_editor = require("./resolution_editor");
var _is_metric_countable = require("../../util/is_metric_countable");
var _render_as_select = require("./render_as_select");
var _es_geo_grid_source = require("./es_geo_grid_source");
var _is_mvt = require("./is_mvt");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UpdateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", void 0);
    (0, _defineProperty2.default)(this, "state", {
      fields: [],
      metricsEditorKey: (0, _uuid.v4)()
    });
    (0, _defineProperty2.default)(this, "_onMetricsChange", metrics => {
      this.props.onChange({
        propName: 'metrics',
        value: metrics
      });
    });
    (0, _defineProperty2.default)(this, "_onResolutionChange", async (resolution, metrics) => {
      await this.props.onChange({
        propName: 'metrics',
        value: metrics
      }, {
        propName: 'resolution',
        value: resolution,
        newLayerType: this._getNewLayerType(this.props.renderAs, resolution)
      });

      // Metrics editor persists metrics in state.
      // Reset metricsEditorKey to force new instance and new internal state with latest metrics
      this.setState({
        metricsEditorKey: (0, _uuid.v4)()
      });
    });
    (0, _defineProperty2.default)(this, "_onRequestTypeSelect", requestType => {
      this.props.onChange({
        propName: 'requestType',
        value: requestType,
        newLayerType: this._getNewLayerType(requestType, this.props.resolution)
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadFields();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadFields() {
    let indexPattern;
    try {
      indexPattern = await (0, _kibana_services.getIndexPatternService)().get(this.props.indexPatternId);
    } catch (err) {
      if (this._isMounted) {
        this.setState({
          loadError: (0, _i18n_getters.getDataViewNotFoundMessage)(this.props.indexPatternId)
        });
      }
      return;
    }
    if (!this._isMounted) {
      return;
    }
    this.setState({
      fields: indexPattern.fields.filter(field => !_public.indexPatterns.isNestedField(field))
    });
  }
  _getNewLayerType(renderAs, resolution) {
    let nextLayerType;
    if (renderAs === _constants.RENDER_AS.HEATMAP) {
      nextLayerType = _constants.LAYER_TYPE.HEATMAP;
    } else if ((0, _is_mvt.isMvt)(renderAs, resolution)) {
      nextLayerType = _constants.LAYER_TYPE.MVT_VECTOR;
    } else {
      nextLayerType = _constants.LAYER_TYPE.GEOJSON_VECTOR;
    }

    // only return newLayerType if there is a change from current layer type
    return nextLayerType !== undefined && nextLayerType !== this.props.currentLayerType ? nextLayerType : undefined;
  }
  _getMetricsFilter() {
    return this.props.currentLayerType === _constants.LAYER_TYPE.HEATMAP ? metric => {
      // these are countable metrics, where blending heatmap color blobs make sense
      return metric.value ? (0, _is_metric_countable.isMetricCountable)(metric.value) : false;
    } : metric => {
      // terms aggregation is not supported with Elasticsearch _mvt endpoint
      // The goal is to remove GeoJSON ESGeoGridSource implemenation and only have MVT ESGeoGridSource implemenation
      // First step is to deprecate terms aggregation for ESGeoGridSource
      // and prevent new uses of terms aggregation for ESGeoGridSource
      return metric.value !== _constants.AGG_TYPE.TERMS;
    };
  }
  _renderMetricsPanel() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h6", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.esGrid.metricsLabel",
      defaultMessage: "Metrics"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_metrics_editor.MetricsEditor, {
      key: this.state.metricsEditorKey,
      allowMultipleMetrics: this.props.currentLayerType !== _constants.LAYER_TYPE.HEATMAP,
      bucketsName: this.props.bucketsName,
      isJoin: false,
      metricsFilter: this._getMetricsFilter(),
      fields: this.state.fields,
      metrics: this.props.metrics,
      onChange: this._onMetricsChange
    }));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this._renderMetricsPanel(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h6", null, this.props.currentLayerType === _constants.LAYER_TYPE.HEATMAP ? _es_geo_grid_source.heatmapTitle : _es_geo_grid_source.clustersTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_resolution_editor.ResolutionEditor, {
      renderAs: this.props.renderAs,
      resolution: this.props.resolution,
      onChange: this._onResolutionChange,
      metrics: this.props.metrics
    }), /*#__PURE__*/_react.default.createElement(_render_as_select.RenderAsSelect, {
      isColumnCompressed: true,
      renderAs: this.props.renderAs,
      onChange: this._onRequestTypeSelect
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }
}
exports.UpdateSourceEditor = UpdateSourceEditor;