"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DistanceForm = DistanceForm;
exports.KM_ABBREVIATION = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _panel_strings = require("../../../../../connected_components/panel_strings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KM_ABBREVIATION = _i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.kilometersAbbreviation', {
  defaultMessage: 'km'
});
exports.KM_ABBREVIATION = KM_ABBREVIATION;
function getDistanceAsNumber(distance) {
  return typeof distance === 'string' ? parseFloat(distance) : distance;
}
function DistanceForm(props) {
  const [distance, setDistance] = (0, _react.useState)(props.initialDistance);
  const distanceAsNumber = getDistanceAsNumber(distance);
  const isDistanceInvalid = isNaN(distanceAsNumber) || distanceAsNumber <= 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.distanceLabel', {
      defaultMessage: 'Distance'
    }),
    isInvalid: isDistanceInvalid,
    error: isDistanceInvalid ? [_i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.invalidDistanceMessage', {
      defaultMessage: 'Value must be a number greater than 0'
    })] : []
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    append: KM_ABBREVIATION,
    "aria-label": _i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.distanceInputAriaLabel', {
      defaultMessage: 'distance input'
    }),
    isInvalid: isDistanceInvalid,
    min: 0,
    onChange: e => {
      setDistance(e.target.value);
    },
    value: distance
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: props.onClose,
    size: "s"
  }, _panel_strings.panelStrings.close)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: isDistanceInvalid || props.initialDistance.toString() === distance.toString(),
    onClick: () => {
      props.onDistanceChange(getDistanceAsNumber(distance));
      props.onClose();
    },
    size: "s"
  }, _panel_strings.panelStrings.apply)))));
}