"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewVectorLayerEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _create_new_index_pattern = require("./create_new_index_pattern");
var _vector_layer = require("../../vector_layer");
var _es_search_source = require("../../../sources/es_search_source");
var _view = require("../../../../connected_components/add_layer_panel/view");
var _kibana_services = require("../../../../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_MAPPINGS = {
  created: {
    properties: {
      '@timestamp': {
        type: 'date'
      },
      user: {
        type: 'keyword'
      }
    }
  }
};
class NewVectorLayerEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      indexName: '',
      indexNameError: '',
      indexingTriggered: false,
      createIndexError: '',
      userHasIndexWritePermissions: true
    });
    (0, _defineProperty2.default)(this, "_createNewIndex", async () => {
      let indexPatternId;
      try {
        const userHasIndexWritePermissions = await this._checkIndexPermissions();
        if (!userHasIndexWritePermissions) {
          this._setCreateIndexError(_i18n.i18n.translate('xpack.maps.layers.newVectorLayerWizard.indexPermissionsError', {
            defaultMessage: `You must have 'create' and 'create_index' index privileges to create and write data to "{indexName}".`,
            values: {
              indexName: this.state.indexName
            }
          }), userHasIndexWritePermissions);
          return;
        }
        const response = await (0, _create_new_index_pattern.createNewIndexAndPattern)({
          indexName: this.state.indexName,
          defaultMappings: DEFAULT_MAPPINGS
        });
        indexPatternId = response.indexPatternId;
      } catch (e) {
        this._setCreateIndexError(e.message);
        return;
      }
      if (!indexPatternId) {
        this._setCreateIndexError(_i18n.i18n.translate('xpack.maps.layers.newVectorLayerWizard.createIndexError', {
          defaultMessage: 'Could not create index with name {message}',
          values: {
            message: this.state.indexName
          }
        }));
        return;
      }
      if (!this._isMounted) {
        return;
      }
      // Creates empty layer
      const sourceDescriptor = _es_search_source.ESSearchSource.createDescriptor({
        indexPatternId,
        geoField: 'coordinates',
        filterByMapBounds: false,
        applyGlobalQuery: false
      });
      const layerDescriptor = _vector_layer.GeoJsonVectorLayer.createDescriptor({
        sourceDescriptor
      }, this.props.mapColors);
      this.props.previewLayers([layerDescriptor]);
      this.props.advanceToNextStep();
    });
    (0, _defineProperty2.default)(this, "_onIndexChange", (indexName, indexError) => {
      this.setState({
        indexName,
        indexNameError: indexError ? indexError : ''
      });
      if (indexName && !indexError) {
        this.props.enableNextBtn();
      } else {
        this.props.disableNextBtn();
      }
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async componentDidUpdate() {
    if (this.props.currentStepId === _view.ADD_LAYER_STEP_ID && !this.state.indexingTriggered) {
      this.setState({
        indexingTriggered: true
      });
      await this._createNewIndex();
    }
  }
  _setCreateIndexError(errorMessage, userHasIndexWritePermissions = true) {
    if (!this._isMounted) {
      return;
    }
    this.setState({
      createIndexError: errorMessage,
      userHasIndexWritePermissions
    });
  }
  async _checkIndexPermissions() {
    return await (0, _kibana_services.getFileUpload)().hasImportPermission({
      checkCreateDataView: true,
      checkHasManagePipeline: false,
      indexName: this.state.indexName
    });
  }
  render() {
    if (this.state.createIndexError) {
      if (!this.state.userHasIndexWritePermissions) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          title: _i18n.i18n.translate('xpack.maps.layers.newVectorLayerWizard.indexPrivsErrorTitle', {
            defaultMessage: 'Missing index privileges'
          }),
          color: "danger",
          iconType: "warning"
        }, /*#__PURE__*/_react.default.createElement("p", null, this.state.createIndexError));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.maps.layers.newVectorLayerWizard.createIndexErrorTitle', {
          defaultMessage: 'Unable to create index'
        }),
        color: "danger",
        iconType: "warning"
      }, /*#__PURE__*/_react.default.createElement("p", null, this.state.createIndexError));
    }
    const IndexNameForm = (0, _kibana_services.getIndexNameFormComponent)();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(IndexNameForm, {
      indexName: this.state.indexName,
      indexNameError: this.state.indexNameError,
      onIndexNameChange: this._onIndexChange,
      onIndexNameValidationStart: () => {},
      onIndexNameValidationEnd: () => {}
    }));
  }
}
exports.NewVectorLayerEditor = NewVectorLayerEditor;