"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapAttributesSchema = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  description: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  mapStateJSON: _configSchema.schema.maybe(_configSchema.schema.string()),
  layerListJSON: _configSchema.schema.maybe(_configSchema.schema.string()),
  uiStateJSON: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'forbid'
});
const mapSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(mapAttributesSchema);
const searchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  onlyTitle: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  unknowns: 'forbid'
}));
const createOptionsSchema = _configSchema.schema.object({
  references: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.references)
});

// Content management service definition.
// We need it for BWC support between different versions of the content
const serviceDefinition = {
  get: {
    out: {
      result: {
        schema: (0, _contentManagementUtils.objectTypeToGetResultSchema)(mapSavedObjectSchema)
      }
    }
  },
  create: {
    in: {
      options: {
        schema: createOptionsSchema
      },
      data: {
        schema: mapAttributesSchema
      }
    },
    out: {
      result: {
        schema: (0, _contentManagementUtils.createResultSchema)(mapSavedObjectSchema)
      }
    }
  },
  update: {
    in: {
      options: {
        schema: createOptionsSchema // same schema as "create"
      },

      data: {
        schema: mapAttributesSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: searchOptionsSchema
      }
    }
  },
  mSearch: {
    out: {
      result: {
        schema: mapSavedObjectSchema
      }
    }
  }
};
exports.serviceDefinition = serviceDefinition;