"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exceptionsBuilderReducer = void 0;
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const exceptionsBuilderReducer = () => (state, action) => {
  switch (action.type) {
    case 'setExceptions':
      {
        const isAndLogicIncluded = action.exceptions.filter(({
          entries
        }) => entries.length > 1).length > 0;
        const [lastExceptionItem] = action.exceptions.slice(-1);
        const isAddNested = lastExceptionItem != null ? lastExceptionItem.entries.slice(-1).filter(({
          type
        }) => type === 'nested').length > 0 : false;
        const lastEntry = lastExceptionItem != null ? lastExceptionItem.entries.slice(-1)[0] : null;
        const isAndDisabled = lastEntry != null && lastEntry.type === 'nested' && lastEntry.entries.length === 0;
        const isOrDisabled = lastEntry != null && lastEntry.type === 'nested';
        const containsValueList = action.exceptions.some(({
          entries
        }) => entries.filter(({
          type
        }) => type === _securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST).length > 0);
        return {
          ...state,
          addNested: isAddNested,
          andLogicIncluded: isAndLogicIncluded,
          disableAnd: isAndDisabled,
          disableNested: containsValueList,
          disableOr: isOrDisabled,
          exceptions: action.exceptions
        };
      }
    case 'setDefault':
      {
        return {
          ...state,
          ...action.initialState,
          exceptions: [{
            ...action.lastException,
            entries: [(0, _securitysolutionListUtils.getDefaultEmptyEntry)()]
          }]
        };
      }
    case 'setExceptionsToDelete':
      {
        return {
          ...state,
          exceptionsToDelete: action.exceptions
        };
      }
    case 'setDisableAnd':
      {
        return {
          ...state,
          disableAnd: action.shouldDisable
        };
      }
    case 'setDisableOr':
      {
        return {
          ...state,
          disableOr: action.shouldDisable
        };
      }
    case 'setAddNested':
      {
        return {
          ...state,
          addNested: action.addNested
        };
      }
    case 'setErrorsExist':
      {
        const newErrorsState = {
          ...state.errors,
          ...action.error
        };
        return {
          ...state,
          errors: newErrorsState
        };
      }
    case 'setWarningsExist':
      {
        const {
          warningExists
        } = state;
        const warnTotal = action.warningExists ? warningExists + 1 : warningExists - 1;
        return {
          ...state,
          warningExists: warnTotal < 0 ? 0 : warnTotal
        };
      }
    default:
      return state;
  }
};
exports.exceptionsBuilderReducer = exceptionsBuilderReducer;