"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BuilderEntryDeleteButtonComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyFirstRowContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding-top: 25px;
`;
const BuilderEntryDeleteButtonComponent = /*#__PURE__*/_react.default.memo(({
  entries,
  nestedParentIndex,
  isOnlyItem,
  entryIndex,
  exceptionItemIndex,
  onDelete
}) => {
  const isDisabled = isOnlyItem && entries.length === 1 && exceptionItemIndex === 0 && (entries[0].field == null || entries[0].field === '');
  const handleDelete = (0, _react.useCallback)(() => {
    onDelete(entryIndex, nestedParentIndex);
  }, [onDelete, entryIndex, nestedParentIndex]);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    onClick: handleDelete,
    isDisabled: isDisabled,
    "aria-label": "entryDeleteButton",
    className: "exceptionItemEntryDeleteButton",
    "data-test-subj": "builderItemEntryDeleteButton"
  });
  if (entryIndex === 0 && exceptionItemIndex === 0 && nestedParentIndex == null) {
    // This logic was added to work around it including the field
    // labels in centering the delete icon for the first row
    return /*#__PURE__*/_react.default.createElement(MyFirstRowContainer, {
      grow: false,
      "data-test-subj": "firstRowBuilderDeleteButton"
    }, button);
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "builderDeleteButton"
    }, button);
  }
});
exports.BuilderEntryDeleteButtonComponent = BuilderEntryDeleteButtonComponent;
BuilderEntryDeleteButtonComponent.displayName = 'BuilderEntryDeleteButton';