"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerHeader = LayerHeader;
exports.LayerHeaderContent = LayerHeaderContent;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _chartIcons = require("@kbn/chart-icons");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _data_view_picker_icon = require("../../../shared_components/ignore_global_filter/data_view_picker_icon");
var _types = require("../types");
var _state_helpers = require("../state_helpers");
var _shared_components = require("../../../shared_components");
var _ = require(".");
var _visualization_helpers = require("../visualization_helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LayerHeader(props) {
  const layer = props.state.layers.find(l => l.layerId === props.layerId);
  if (!layer) {
    return null;
  }
  if ((0, _visualization_helpers.isReferenceLayer)(layer)) {
    return /*#__PURE__*/_react.default.createElement(ReferenceLayerHeader, null);
  }
  if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
    return /*#__PURE__*/_react.default.createElement(AnnotationsLayerHeader, {
      title: (0, _visualization_helpers.isByReferenceAnnotationsLayer)(layer) ? layer.__lastSaved.title : undefined,
      hasUnsavedChanges: (0, _state_helpers.annotationLayerHasUnsavedChanges)(layer)
    });
  }
  return /*#__PURE__*/_react.default.createElement(DataLayerHeader, props);
}
function LayerHeaderContent(props) {
  const layer = props.state.layers.find(l => l.layerId === props.layerId);
  if (layer && (0, _visualization_helpers.isAnnotationsLayer)(layer)) {
    return /*#__PURE__*/_react.default.createElement(AnnotationLayerHeaderContent, props);
  }
  return null;
}
function ReferenceLayerHeader() {
  return /*#__PURE__*/_react.default.createElement(_shared_components.StaticHeader, {
    icon: _chartIcons.IconChartBarReferenceLine,
    label: _i18n.i18n.translate('xpack.lens.xyChart.layerReferenceLineLabel', {
      defaultMessage: 'Reference lines'
    })
  });
}
function AnnotationsLayerHeader({
  title,
  hasUnsavedChanges
}) {
  return /*#__PURE__*/_react.default.createElement(_shared_components.StaticHeader, {
    icon: _chartIcons.IconChartBarAnnotations,
    label: title || _i18n.i18n.translate('xpack.lens.xyChart.layerAnnotationsLabel', {
      defaultMessage: 'Annotations'
    }),
    indicator: hasUnsavedChanges && /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
              padding-bottom: 3px;
              padding-left: 4px;
            `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.lens.xyChart.unsavedChanges', {
        defaultMessage: 'Unsaved changes'
      }),
      type: "dot",
      color: _uiTheme.euiThemeVars.euiColorSuccess
    }))
  });
}
function AnnotationLayerHeaderContent({
  frame,
  state,
  layerId,
  onChangeIndexPattern
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const notFoundTitleLabel = _i18n.i18n.translate('xpack.lens.layerPanel.missingDataView', {
    defaultMessage: 'Data view not found'
  });
  const layerIndex = state.layers.findIndex(l => l.layerId === layerId);
  const layer = state.layers[layerIndex];
  const currentIndexPattern = frame.dataViews.indexPatterns[layer.indexPatternId];
  return /*#__PURE__*/_react.default.createElement(_shared_components.ChangeIndexPattern, {
    "data-test-subj": "indexPattern-switcher",
    trigger: {
      label: (currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.name) || notFoundTitleLabel,
      title: (currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.title) || notFoundTitleLabel,
      'data-test-subj': 'lns_layerIndexPatternLabel',
      size: 's',
      fontWeight: 'normal',
      extraIcons: layer.ignoreGlobalFilters ? [(0, _data_view_picker_icon.getIgnoreGlobalFilterIcon)({
        color: euiTheme.colors.disabledText,
        dataTestSubj: 'lnsChangeIndexPatternIgnoringFilters'
      })] : undefined
    },
    indexPatternId: layer.indexPatternId,
    indexPatternRefs: frame.dataViews.indexPatternRefs,
    isMissingCurrent: !currentIndexPattern,
    onChangeIndexPattern: onChangeIndexPattern
  });
}
function DataLayerHeader(props) {
  const [isPopoverOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  const {
    state,
    layerId
  } = props;
  const layers = state.layers.filter(_visualization_helpers.isDataLayer);
  const layer = layers.find(l => l.layerId === layerId);
  const index = state.layers.findIndex(l => l === layer);
  const currentVisType = _types.visualizationTypes.find(({
    id
  }) => id === layer.seriesType);
  const horizontalOnly = (0, _state_helpers.isHorizontalChart)(state.layers);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelClassName: "lnsChangeIndexPatternPopover",
    button: /*#__PURE__*/_react.default.createElement(DataLayerHeaderTrigger, {
      onClick: () => setPopoverIsOpen(!isPopoverOpen),
      currentVisType: currentVisType
    }),
    isOpen: isPopoverOpen,
    closePopover: () => setPopoverIsOpen(false),
    display: "block",
    panelPaddingSize: "s",
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('xpack.lens.layerPanel.layerVisualizationType', {
    defaultMessage: 'Layer visualization type'
  })), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    singleSelection: "always",
    options: _types.visualizationTypes.filter(t => (0, _state_helpers.isHorizontalSeries)(t.id) === horizontalOnly).map(t => ({
      value: t.id,
      key: t.id,
      checked: t.id === currentVisType.id ? 'on' : undefined,
      prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: t.icon
      }),
      label: t.fullLabel || t.label,
      'data-test-subj': `lnsXY_seriesType-${t.id}`
    })),
    onChange: newOptions => {
      const chosenType = newOptions.find(({
        checked
      }) => checked === 'on');
      if (!chosenType) {
        return;
      }
      const id = chosenType.value;
      props.setState((0, _.updateLayer)(state, {
        ...layer,
        seriesType: id
      }, index));
      setPopoverIsOpen(false);
    }
  }, list => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, list))));
}
const DataLayerHeaderTrigger = function ({
  currentVisType,
  onClick
}) {
  return /*#__PURE__*/_react.default.createElement(_public.ToolbarButton, {
    "data-test-subj": "lns_layer_settings",
    title: currentVisType.fullLabel || currentVisType.label,
    onClick: onClick,
    fullWidth: true,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: currentVisType.icon
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "lnsLayerPanelChartSwitch_title"
  }, currentVisType.fullLabel || currentVisType.label)));
};