"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddLayerButton = AddLayerButton;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/expression-xy-plugin/public");
var _load_annotation_library_flyout = require("./load_annotation_library_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AddLayerButton({
  supportedLayers,
  addLayer,
  eventAnnotationService
}) {
  const [showLayersChoice, toggleLayersChoice] = (0, _react.useState)(false);
  const [isLoadLibraryVisible, setLoadLibraryFlyoutVisible] = (0, _react.useState)(false);
  const annotationPanel = ({
    type,
    label,
    icon,
    disabled,
    toolTipContent
  }) => {
    return {
      panel: 1,
      toolTipContent,
      disabled,
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "m",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", {
        className: "lnsLayerAddButton__label"
      }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        className: "lnsLayerAddButton__techBadge",
        color: "hollow",
        isDisabled: disabled
      }, _i18n.i18n.translate('xpack.lens.configPanel.experimentalLabel', {
        defaultMessage: 'Technical preview'
      })))),
      className: 'lnsLayerAddButton',
      icon: icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: icon
      }),
      ['data-test-subj']: `lnsLayerAddButton-${type}`
    };
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    display: "block",
    "data-test-subj": "lnsConfigPanel__addLayerPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fullWidth: true,
      "data-test-subj": "lnsLayerAddButton",
      "aria-label": _i18n.i18n.translate('xpack.lens.configPanel.addLayerButton', {
        defaultMessage: 'Add layer'
      }),
      fill: true,
      color: "text",
      onClick: () => toggleLayersChoice(!showLayersChoice),
      iconType: "layers"
    }, _i18n.i18n.translate('xpack.lens.configPanel.addLayerButton', {
      defaultMessage: 'Add layer'
    })),
    isOpen: showLayersChoice,
    closePopover: () => toggleLayersChoice(false),
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      title: _i18n.i18n.translate('xpack.lens.configPanel.selectLayerType', {
        defaultMessage: 'Select layer type'
      }),
      width: 300,
      items: supportedLayers.map(props => {
        const {
          type,
          label,
          icon,
          disabled,
          toolTipContent
        } = props;
        if (type === _public.LayerTypes.ANNOTATIONS) {
          return annotationPanel(props);
        }
        return {
          toolTipContent,
          disabled,
          name: /*#__PURE__*/_react.default.createElement("span", {
            className: "lnsLayerAddButtonLabel"
          }, label),
          className: 'lnsLayerAddButton',
          icon: icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            size: "m",
            type: icon
          }),
          ['data-test-subj']: `lnsLayerAddButton-${type}`,
          onClick: () => {
            addLayer(type);
            toggleLayersChoice(false);
          }
        };
      })
    }, {
      id: 1,
      initialFocusedItemIndex: 0,
      title: _i18n.i18n.translate('xpack.lens.configPanel.selectAnnotationMethod', {
        defaultMessage: 'Select annotation method'
      }),
      items: [{
        name: _i18n.i18n.translate('xpack.lens.configPanel.newAnnotation', {
          defaultMessage: 'New annotation'
        }),
        icon: 'plusInCircle',
        onClick: () => {
          addLayer(_public.LayerTypes.ANNOTATIONS);
          toggleLayersChoice(false);
        },
        'data-test-subj': 'lnsAnnotationLayer_new'
      }, {
        name: _i18n.i18n.translate('xpack.lens.configPanel.loadFromLibrary', {
          defaultMessage: 'Load from library'
        }),
        icon: 'folderOpen',
        onClick: () => {
          setLoadLibraryFlyoutVisible(true);
          toggleLayersChoice(false);
        },
        'data-test-subj': 'lnsAnnotationLayer_addFromLibrary'
      }]
    }]
  })), isLoadLibraryVisible && /*#__PURE__*/_react.default.createElement(_load_annotation_library_flyout.LoadAnnotationLibraryFlyout, {
    isLoadLibraryVisible: isLoadLibraryVisible,
    setLoadLibraryFlyoutVisible: setLoadLibraryFlyoutVisible,
    eventAnnotationService: eventAnnotationService,
    addLayer: extraArg => {
      addLayer(_public.LayerTypes.ANNOTATIONS, extraArg);
    }
  }));
}