"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isLensBrushEvent = isLensBrushEvent;
exports.isLensEditEvent = isLensEditEvent;
exports.isLensFilterEvent = isLensFilterEvent;
exports.isLensMultiFilterEvent = isLensMultiFilterEvent;
exports.isLensTableRowContextMenuClickEvent = isLensTableRowContextMenuClickEvent;
exports.isMessageRemovable = isMessageRemovable;
exports.isOperation = isOperation;
var _constants = require("./visualizations/datatable/components/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isMessageRemovable(message) {
  return Boolean(message.uniqueId);
}

/**
 * Interface for the datasource registry
 */

function isOperation(operationCandidate) {
  return typeof operationCandidate === 'object' && operationCandidate !== null && 'columnId' in operationCandidate;
}
function isLensFilterEvent(event) {
  return event.name === 'filter';
}
function isLensMultiFilterEvent(event) {
  return event.name === 'multiFilter';
}
function isLensBrushEvent(event) {
  return event.name === 'brush';
}
function isLensEditEvent(event) {
  return event.name === 'edit';
}
function isLensTableRowContextMenuClickEvent(event) {
  return event.name === 'tableRowContextMenuClick';
}

/**
 * Expression renderer handlers specifically for lens renderers. This is a narrowed down
 * version of the general render handlers, specifying supported event types. If this type is
 * used, dispatched events will be handled correctly.
 */