"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiscoverHelpersAsync = exports.OpenInDiscoverDrilldown = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/data-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const getDiscoverHelpersAsync = async () => await Promise.resolve().then(() => _interopRequireWildcard(require('../async_services')));

/** @internal */
exports.getDiscoverHelpersAsync = getDiscoverHelpersAsync;
class OpenInDiscoverDrilldown {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", 'OPEN_IN_DISCOVER_DRILLDOWN');
    (0, _defineProperty2.default)(this, "order", 8);
    (0, _defineProperty2.default)(this, "getDisplayName", () => _i18n.i18n.translate('xpack.lens.app.exploreDataInDiscoverDrilldown', {
      defaultMessage: 'Open in Discover'
    }));
    (0, _defineProperty2.default)(this, "euiIcon", 'discoverApp');
    (0, _defineProperty2.default)(this, "ReactCollectConfig", ({
      config,
      onConfig
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        hasChildLabel: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        id: "openInNewTab",
        name: "openInNewTab",
        label: _i18n.i18n.translate('xpack.lens.app.exploreDataInDiscoverDrilldown.newTabConfig', {
          defaultMessage: 'Open in new tab'
        }),
        checked: config.openInNewTab,
        onChange: () => onConfig({
          ...config,
          openInNewTab: !config.openInNewTab
        }),
        "data-test-subj": "openInDiscoverDrilldownOpenInNewTab"
      }));
    });
    (0, _defineProperty2.default)(this, "CollectConfig", this.ReactCollectConfig);
    (0, _defineProperty2.default)(this, "createConfig", () => ({
      openInNewTab: true
    }));
    (0, _defineProperty2.default)(this, "isConfigValid", config => {
      return true;
    });
    (0, _defineProperty2.default)(this, "isCompatible", async (config, context) => {
      const {
        isCompatible
      } = await getDiscoverHelpersAsync();
      return isCompatible({
        locator: this.deps.locator(),
        dataViews: this.deps.dataViews(),
        hasDiscoverAccess: this.deps.hasDiscoverAccess(),
        ...context,
        embeddable: context.embeddable,
        ...config
      });
    });
    (0, _defineProperty2.default)(this, "isConfigurable", context => {
      var _context$embeddable;
      return this.deps.hasDiscoverAccess() && ((_context$embeddable = context.embeddable) === null || _context$embeddable === void 0 ? void 0 : _context$embeddable.type) === _constants.DOC_TYPE;
    });
    (0, _defineProperty2.default)(this, "getHref", async (config, context) => {
      const {
        getHref
      } = await getDiscoverHelpersAsync();
      return getHref({
        locator: this.deps.locator(),
        dataViews: this.deps.dataViews(),
        hasDiscoverAccess: this.deps.hasDiscoverAccess(),
        ...context,
        embeddable: context.embeddable
      });
    });
    (0, _defineProperty2.default)(this, "execute", async (config, context) => {
      if (config.openInNewTab) {
        window.open(await this.getHref(config, context), '_blank');
      } else {
        const {
          getLocation
        } = await getDiscoverHelpersAsync();
        const {
          app,
          path,
          state
        } = await getLocation({
          locator: this.deps.locator(),
          dataViews: this.deps.dataViews(),
          hasDiscoverAccess: this.deps.hasDiscoverAccess(),
          ...context,
          embeddable: context.embeddable
        });
        await this.deps.application().navigateToApp(app, {
          path,
          state
        });
      }
    });
    this.deps = deps;
  }
  supportedTriggers() {
    return [_public.APPLY_FILTER_TRIGGER];
  }
}
exports.OpenInDiscoverDrilldown = OpenInDiscoverDrilldown;