"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIgnoreGlobalFilterIcon = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieve the IgnoreGlobalfilter shared icon to be put into the dataViewPicker within a Layer panel
 * @param dataTestSubj test id to be applied
 * @returns
 */
const getIgnoreGlobalFilterIcon = ({
  color,
  dataTestSubj
}) => {
  return {
    component: /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: 'filterIgnore',
      color: color,
      css: (0, _react.css)`
          margin-top: 15px;
        `
    }),
    tooltipValue: _i18n.i18n.translate('xpack.lens.layerPanel.ignoreGlobalFilters', {
      defaultMessage: 'Ignore global filters'
    }),
    'data-test-subj': dataTestSubj
  };
};
exports.getIgnoreGlobalFilterIcon = getIgnoreGlobalFilterIcon;