"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TriggerButton = TriggerButton;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _toolbar_button = require("./toolbar_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TriggerLabel({
  label,
  extraIcons
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!(extraIcons !== null && extraIcons !== void 0 && extraIcons.length)) {
    return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, label);
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textTruncate",
    css: (0, _react.css)`
          display: block;
          min-width: 0;
        `
  }, label), extraIcons.map(icon => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": icon['data-test-subj'],
    css: (0, _react.css)`
            display: block;
            *:hover &,
            *:focus & {
              text-decoration: none !important;
            }
          `,
    key: icon['data-test-subj']
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: icon.tooltipValue,
    position: "top",
    "data-test-subj": `${icon['data-test-subj']}-tooltip`
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, icon.component), icon.value ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
    color: euiTheme.colors.disabledText
  }, icon.value)) : null)))));
}
function TriggerButton({
  label,
  title,
  togglePopover,
  isMissingCurrent,
  extraIcons,
  ...rest
}) {
  // be careful to only add color with a value, otherwise it will fallbacks to "primary"
  const colorProp = isMissingCurrent ? {
    color: 'danger'
  } : {};
  return /*#__PURE__*/_react2.default.createElement(_toolbar_button.ToolbarButton, (0, _extends2.default)({
    title: title,
    onClick: () => togglePopover(),
    fullWidth: true
  }, colorProp, rest, {
    textProps: {
      style: {
        width: '100%'
      }
    }
  }), /*#__PURE__*/_react2.default.createElement(TriggerLabel, {
    label: label,
    extraIcons: extraIcons
  }));
}