"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PalettePanelContainer = PalettePanelContainer;
require("./palette_panel_container.scss");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PalettePanelContainer({
  isOpen,
  handleClose,
  siblingRef,
  children
}) {
  const [focusTrapIsEnabled, setFocusTrapIsEnabled] = (0, _react.useState)(false);
  const closeFlyout = () => {
    handleClose();
    setFocusTrapIsEnabled(false);
  };
  (0, _react.useEffect)(() => {
    if (isOpen) {
      // without setTimeout here the flyout pushes content when animating
      setTimeout(() => {
        setFocusTrapIsEnabled(true);
      }, 255);
    }
  }, [isOpen]);
  return isOpen && siblingRef.current ? /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    insert: {
      sibling: siblingRef.current,
      position: 'after'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    disabled: !focusTrapIsEnabled,
    clickOutsideDisables: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: closeFlyout,
    isDisabled: !isOpen
  }, /*#__PURE__*/_react.default.createElement("div", {
    role: "dialog",
    "aria-labelledby": "lnsPalettePanelContainerTitle",
    "data-test-subj": "lns-indexPattern-PalettePanelContainer",
    className: "lnsPalettePanelContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    className: "lnsPalettePanelContainer__header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    "data-test-subj": "lns-indexPattern-PalettePanelContainerBack",
    className: "lnsPalettePanelContainer__backIcon",
    onClick: closeFlyout,
    iconType: "sortLeft",
    "aria-label": _i18n.i18n.translate('xpack.lens.table.palettePanelContainer.back', {
      defaultMessage: 'Back'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "lnsPalettePanelContainerTitle",
    className: "lnsPalettePanelContainer__headerTitle"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.lens.table.palettePanelTitle', {
    defaultMessage: 'Color'
  }))))))), children && /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsPalettePanelContainer__content"
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "lnsPalettePanelContainer__footer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    iconType: "sortLeft",
    onClick: closeFlyout
  }, _i18n.i18n.translate('xpack.lens.table.palettePanelContainer.back', {
    defaultMessage: 'Back'
  }))))))) : null;
}