"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectIndexStore = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SavedObjectIndexStore {
  constructor(client) {
    (0, _defineProperty2.default)(this, "client", void 0);
    (0, _defineProperty2.default)(this, "save", async vis => {
      const {
        savedObjectId,
        type,
        references,
        ...rest
      } = vis;
      const attributes = rest;
      if (savedObjectId) {
        const result = await this.client.update({
          contentTypeId: 'lens',
          id: savedObjectId,
          data: attributes,
          options: {
            references
          }
        });
        return {
          ...vis,
          savedObjectId: result.item.id
        };
      } else {
        const result = await this.client.create({
          contentTypeId: 'lens',
          data: attributes,
          options: {
            references
          }
        });
        return {
          ...vis,
          savedObjectId: result.item.id
        };
      }
    });
    this.client = client;
  }
  async load(savedObjectId) {
    const resolveResult = await this.client.get({
      contentTypeId: _constants.DOC_TYPE,
      id: savedObjectId
    });
    if (resolveResult.item.error) {
      throw resolveResult.item.error;
    }
    return resolveResult;
  }
  async search(query, options) {
    const result = await this.client.search({
      contentTypeId: _constants.DOC_TYPE,
      query,
      options
    });
    return result;
  }
}
exports.SavedObjectIndexStore = SavedObjectIndexStore;