"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NativeRenderer = NativeRenderer;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A component which takes care of providing a mountpoint for a generic render
 * function which takes an html element and an optional props object.
 * By default the mountpoint element will be a div, this can be changed with the
 * `tag` prop.
 *
 * If the rendered component tree was using React, we need to clean it up manually,
 * otherwise the unmount event never happens. A future addition is for non-React components
 * to get cleaned up, which could be added in the future.
 *
 * @param props
 */
function NativeRenderer({
  render,
  nativeProps,
  tag,
  ...rest
}) {
  const elementRef = (0, _react.useRef)();
  const cleanupRef = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    return () => {
      if (elementRef.current) {
        if (cleanupRef.current && typeof cleanupRef.current === 'function') {
          cleanupRef.current(elementRef.current);
        }
        (0, _reactDom.unmountComponentAtNode)(elementRef.current);
      }
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(tag || 'div', {
    ...rest,
    ref: el => {
      if (el) {
        elementRef.current = el;
        // Handles the editor frame renderer, which is async
        const result = render(el, nativeProps);
        if (result instanceof Promise) {
          result.then(cleanup => {
            if (typeof cleanup === 'function') {
              cleanupRef.current = cleanup;
            }
          });
        } else if (typeof result === 'function') {
          cleanupRef.current = result;
        }
      }
    }
  });
}