"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _constants = require("../../common/constants");
var _embeddable_factory = require("../../common/embeddable_factory");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class EmbeddableFactory {
  constructor(getStartServices) {
    (0, _defineProperty2.default)(this, "type", _constants.DOC_TYPE);
    (0, _defineProperty2.default)(this, "savedObjectMetaData", {
      name: _i18n.i18n.translate('xpack.lens.lensSavedObjectLabel', {
        defaultMessage: 'Lens Visualization'
      }),
      type: _constants.DOC_TYPE,
      getIconForSavedObject: () => 'lensApp'
    });
    (0, _defineProperty2.default)(this, "isEditable", async () => {
      var _capabilities$dashboa;
      const {
        capabilities
      } = await this.getStartServices();
      return Boolean(capabilities.visualize.save || ((_capabilities$dashboa = capabilities.dashboard) === null || _capabilities$dashboa === void 0 ? void 0 : _capabilities$dashboa.showWriteControls));
    });
    (0, _defineProperty2.default)(this, "createFromSavedObject", async (savedObjectId, input, parent) => {
      if (!input.savedObjectId) {
        input.savedObjectId = savedObjectId;
      }
      return this.create(input, parent);
    });
    (0, _defineProperty2.default)(this, "extract", _embeddable_factory.extract);
    (0, _defineProperty2.default)(this, "inject", _embeddable_factory.inject);
    this.getStartServices = getStartServices;
  }
  canCreateNew() {
    return false;
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.lens.embeddableDisplayName', {
      defaultMessage: 'Lens'
    });
  }
  async create(input, parent) {
    try {
      var _capabilities$dashboa2;
      const {
        data,
        timefilter,
        expressionRenderer,
        documentToExpression,
        injectFilterReferences,
        visualizationMap,
        datasourceMap,
        uiActions,
        coreHttp,
        coreStart,
        attributeService,
        dataViews,
        capabilities,
        usageCollection,
        theme,
        inspector,
        spaces,
        uiSettings
      } = await this.getStartServices();
      const {
        Embeddable
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../async_services')));
      return new Embeddable({
        attributeService,
        data,
        dataViews,
        timefilter,
        inspector,
        expressionRenderer,
        basePath: coreHttp.basePath,
        getTrigger: uiActions === null || uiActions === void 0 ? void 0 : uiActions.getTrigger,
        getTriggerCompatibleActions: uiActions === null || uiActions === void 0 ? void 0 : uiActions.getTriggerCompatibleActions,
        documentToExpression,
        injectFilterReferences,
        visualizationMap,
        datasourceMap,
        capabilities: {
          canSaveDashboards: Boolean((_capabilities$dashboa2 = capabilities.dashboard) === null || _capabilities$dashboa2 === void 0 ? void 0 : _capabilities$dashboa2.showWriteControls),
          canSaveVisualizations: Boolean(capabilities.visualize.save),
          canOpenVisualizations: Boolean(capabilities.visualize.show),
          navLinks: capabilities.navLinks,
          discover: capabilities.discover
        },
        coreStart,
        usageCollection,
        theme,
        spaces,
        uiSettings
      }, input, parent);
    } catch (e) {
      return new _public.ErrorEmbeddable(e, input, parent);
    }
  }
}
exports.EmbeddableFactory = EmbeddableFactory;