"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorFrame = EditorFrame;
var _react = _interopRequireWildcard(require("react"));
var _domDragDrop = require("@kbn/dom-drag-drop");
var _lens_ui_telemetry = require("../../lens_ui_telemetry");
var _data_panel_wrapper = require("./data_panel_wrapper");
var _banner_wrapper = require("./banner_wrapper");
var _config_panel = require("./config_panel");
var _frame_layout = require("./frame_layout");
var _suggestion_panel = require("./suggestion_panel");
var _workspace_panel = require("./workspace_panel");
var _suggestion_helpers = require("./suggestion_helpers");
var _state_management = require("../../state_management");
var _lens_ui_errors = require("../../lens_ui_errors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EditorFrame(props) {
  const {
    datasourceMap,
    visualizationMap
  } = props;
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const activeDatasourceId = (0, _state_management.useLensSelector)(_state_management.selectActiveDatasourceId);
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const visualization = (0, _state_management.useLensSelector)(_state_management.selectVisualization);
  const areDatasourcesLoaded = (0, _state_management.useLensSelector)(_state_management.selectAreDatasourcesLoaded);
  const isVisualizationLoaded = !!visualization.state;
  const visualizationTypeIsKnown = Boolean(visualization.activeId && props.visualizationMap[visualization.activeId]);
  const framePublicAPI = (0, _state_management.useLensSelector)(state => (0, _state_management.selectFramePublicAPI)(state, datasourceMap));

  // Using a ref to prevent rerenders in the child components while keeping the latest state
  const getSuggestionForField = (0, _react.useRef)();
  getSuggestionForField.current = field => {
    if (!field || !activeDatasourceId) {
      return;
    }
    return (0, _suggestion_helpers.getTopSuggestionForField)(framePublicAPI.datasourceLayers, visualization, datasourceStates, visualizationMap, datasourceMap[activeDatasourceId], field, framePublicAPI.dataViews, true);
  };
  const hasSuggestionForField = (0, _react.useCallback)(field => getSuggestionForField.current(field) !== undefined, [getSuggestionForField]);
  const dropOntoWorkspace = (0, _react.useCallback)(field => {
    const suggestion = getSuggestionForField.current(field);
    if (suggestion) {
      (0, _lens_ui_telemetry.trackUiCounterEvents)('drop_onto_workspace');
      (0, _suggestion_helpers.switchToSuggestion)(dispatchLens, suggestion, {
        clearStagedPreview: true
      });
    }
  }, [getSuggestionForField, dispatchLens]);
  const onError = (0, _react.useCallback)(error => {
    (0, _lens_ui_errors.showMemoizedErrorNotification)(error);
  }, []);
  const bannerMessages = props.getUserMessages('banner', {
    severity: 'warning'
  });
  return /*#__PURE__*/_react.default.createElement(_domDragDrop.RootDragDropProvider, {
    dataTestSubj: "lnsDragDrop",
    onTrackUICounterEvent: _lens_ui_telemetry.trackUiCounterEvents
  }, /*#__PURE__*/_react.default.createElement(_frame_layout.FrameLayout, {
    bannerMessages: bannerMessages.length ? /*#__PURE__*/_react.default.createElement(_lens_ui_errors.ErrorBoundary, {
      onError: onError
    }, /*#__PURE__*/_react.default.createElement(_banner_wrapper.BannerWrapper, {
      nodes: bannerMessages.map(({
        longMessage
      }) => longMessage)
    })) : undefined,
    dataPanel: /*#__PURE__*/_react.default.createElement(_lens_ui_errors.ErrorBoundary, {
      onError: onError
    }, /*#__PURE__*/_react.default.createElement(_data_panel_wrapper.DataPanelWrapper, {
      core: props.core,
      plugins: props.plugins,
      datasourceMap: datasourceMap,
      visualizationMap: visualizationMap,
      showNoDataPopover: props.showNoDataPopover,
      dropOntoWorkspace: dropOntoWorkspace,
      hasSuggestionForField: hasSuggestionForField,
      indexPatternService: props.indexPatternService,
      frame: framePublicAPI
    })),
    configPanel: areDatasourcesLoaded && /*#__PURE__*/_react.default.createElement(_lens_ui_errors.ErrorBoundary, {
      onError: onError
    }, /*#__PURE__*/_react.default.createElement(_config_panel.ConfigPanelWrapper, {
      core: props.core,
      datasourceMap: datasourceMap,
      visualizationMap: visualizationMap,
      framePublicAPI: framePublicAPI,
      uiActions: props.plugins.uiActions,
      dataViews: props.plugins.dataViews,
      indexPatternService: props.indexPatternService,
      getUserMessages: props.getUserMessages
    })),
    workspacePanel: areDatasourcesLoaded && isVisualizationLoaded && /*#__PURE__*/_react.default.createElement(_lens_ui_errors.ErrorBoundary, {
      onError: onError
    }, /*#__PURE__*/_react.default.createElement(_workspace_panel.WorkspacePanel, {
      core: props.core,
      plugins: props.plugins,
      ExpressionRenderer: props.ExpressionRenderer,
      lensInspector: props.lensInspector,
      datasourceMap: datasourceMap,
      visualizationMap: visualizationMap,
      framePublicAPI: framePublicAPI,
      getSuggestionForField: getSuggestionForField.current,
      getUserMessages: props.getUserMessages,
      addUserMessages: props.addUserMessages
    })),
    suggestionsPanel: visualizationTypeIsKnown && areDatasourcesLoaded && /*#__PURE__*/_react.default.createElement(_lens_ui_errors.ErrorBoundary, {
      onError: onError
    }, /*#__PURE__*/_react.default.createElement(_suggestion_panel.SuggestionPanelWrapper, {
      ExpressionRenderer: props.ExpressionRenderer,
      datasourceMap: datasourceMap,
      visualizationMap: visualizationMap,
      frame: framePublicAPI,
      getUserMessages: props.getUserMessages,
      nowProvider: props.plugins.data.nowProvider
    }))
  }));
}