"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextBasedDataPanel = TextBasedDataPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/unified-field-list-plugin/public");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _utils = require("./utils");
var _field_item = require("../common/field_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCustomFieldType = field => field === null || field === void 0 ? void 0 : field.meta.type;
function TextBasedDataPanel({
  setState,
  state,
  dragDropContext,
  core,
  data,
  query,
  frame,
  filters,
  dateRange,
  expressions,
  dataViews,
  layerFields,
  hasSuggestionForField,
  dropOntoWorkspace
}) {
  const prevQuery = (0, _usePrevious.default)(query);
  const [dataHasLoaded, setDataHasLoaded] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    async function fetchData() {
      if (query && (0, _esQuery.isOfAggregateQueryType)(query) && !(0, _lodash.isEqual)(query, prevQuery)) {
        const frameDataViews = frame.dataViews;
        const stateFromQuery = await (0, _utils.getStateFromAggregateQuery)(state, query, dataViews, data, expressions, frameDataViews);
        setDataHasLoaded(true);
        setState(stateFromQuery);
      }
    }
    fetchData();
  }, [data, dataViews, expressions, prevQuery, query, setState, state, frame.dataViews]);
  const {
    fieldList
  } = state;
  const onSelectedFieldFilter = (0, _react.useCallback)(field => {
    return Boolean(layerFields === null || layerFields === void 0 ? void 0 : layerFields.includes(field.name));
  }, [layerFields]);
  const onOverrideFieldGroupDetails = (0, _react.useCallback)(groupName => {
    if (groupName === _public2.FieldsGroupNames.AvailableFields) {
      return {
        helpText: _i18n.i18n.translate('xpack.lens.indexPattern.allFieldsForTextBasedLabelHelp', {
          defaultMessage: 'Drag and drop available fields to the workspace and create visualizations. To change the available fields, edit your query.'
        })
      };
    }
  }, []);
  const {
    fieldListFiltersProps,
    fieldListGroupedProps
  } = (0, _public2.useGroupedFields)({
    dataViewId: null,
    allFields: dataHasLoaded ? fieldList : null,
    services: {
      dataViews,
      core
    },
    getCustomFieldType,
    onSelectedFieldFilter,
    onOverrideFieldGroupDetails
  });
  const renderFieldItem = (0, _react.useCallback)(({
    field,
    groupIndex,
    itemIndex,
    fieldSearchHighlight,
    groupName
  }) => {
    if (!field) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }
    return /*#__PURE__*/_react.default.createElement(_field_item.FieldItem, {
      field: field,
      exists: true,
      hideDetails: true,
      itemIndex: itemIndex,
      groupIndex: groupIndex,
      dropOntoWorkspace: dropOntoWorkspace,
      hasSuggestionForField: hasSuggestionForField,
      highlight: fieldSearchHighlight,
      getCustomFieldType: getCustomFieldType
    });
  }, [hasSuggestionForField, dropOntoWorkspace]);
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core
    }
  }, /*#__PURE__*/_react.default.createElement(_domDragDrop.ChildDragDropProvider, dragDropContext, /*#__PURE__*/_react.default.createElement(_public2.FieldList, {
    className: "lnsInnerIndexPatternDataPanel",
    isProcessing: !dataHasLoaded,
    prepend: /*#__PURE__*/_react.default.createElement(_public2.FieldListFilters, (0, _extends2.default)({}, fieldListFiltersProps, {
      "data-test-subj": "lnsTextBasedLanguages"
    }))
  }, /*#__PURE__*/_react.default.createElement(_public2.FieldListGrouped, (0, _extends2.default)({}, fieldListGroupedProps, {
    renderFieldItem: renderFieldItem,
    "data-test-subj": "lnsTextBasedLanguages",
    localStorageKeyPrefix: "lens"
  })))));
}