"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildLabelFunction = void 0;
exports.checkForDataLayerType = checkForDataLayerType;
exports.checkForDateHistogram = checkForDateHistogram;
exports.checkReferences = checkReferences;
exports.dateBasedOperationToExpression = dateBasedOperationToExpression;
exports.getErrorForRateReference = getErrorForRateReference;
exports.getErrorsForDateReference = getErrorsForDateReference;
exports.hasDateField = hasDateField;
exports.optionallHistogramBasedOperationToExpression = optionallHistogramBasedOperationToExpression;
var _i18n = require("@kbn/i18n");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _public = require("@kbn/expression-xy-plugin/public");
var _time_scale_utils = require("../../time_scale_utils");
var _layer_helpers = require("../../layer_helpers");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildLabelFunction = ofName => (name, timeScale, timeShift) => {
  const rawLabel = ofName(name);
  return (0, _time_scale_utils.adjustTimeScaleLabelSuffix)(rawLabel, undefined, timeScale, undefined, timeShift, undefined, undefined);
};
exports.buildLabelFunction = buildLabelFunction;
function checkForDataLayerType(layerType, name) {
  if (layerType === _public.LayerTypes.REFERENCELINE) {
    return [_i18n.i18n.translate('xpack.lens.indexPattern.calculations.layerDataType', {
      defaultMessage: '{name} is disabled for this type of layer.',
      values: {
        name
      }
    })];
  }
}

/**
 * Checks whether the current layer includes a date histogram and returns an error otherwise
 */
function checkForDateHistogram(layer, name) {
  const buckets = layer.columnOrder.filter(colId => layer.columns[colId].isBucketed);
  const hasDateHistogram = buckets.some(colId => layer.columns[colId].operationType === 'date_histogram');
  if (hasDateHistogram) {
    return undefined;
  }
  return [_i18n.i18n.translate('xpack.lens.indexPattern.calculations.dateHistogramErrorMessage', {
    defaultMessage: '{name} requires a date histogram to work. Add a date histogram or select a different function.',
    values: {
      name
    }
  })];
}
const getFullyManagedColumnIds = (0, _memoizeOne.default)(layer => {
  const managedColumnIds = new Set();
  Object.entries(layer.columns).forEach(([id, column]) => {
    if ('references' in column && _.operationDefinitionMap[column.operationType].input === 'managedReference') {
      managedColumnIds.add(id);
      const managedColumns = (0, _layer_helpers.getManagedColumnsFrom)(id, layer.columns);
      managedColumns.map(([managedId]) => {
        managedColumnIds.add(managedId);
      });
    }
  });
  return managedColumnIds;
});
function checkReferences(layer, columnId) {
  const column = layer.columns[columnId];
  const errors = [];
  column.references.forEach((referenceId, index) => {
    if (!layer.columns[referenceId]) {
      errors.push(_i18n.i18n.translate('xpack.lens.indexPattern.missingReferenceError', {
        defaultMessage: '"{dimensionLabel}" is not fully configured',
        values: {
          dimensionLabel: column.label
        }
      }));
    } else {
      const referenceColumn = layer.columns[referenceId];
      const definition = _.operationDefinitionMap[column.operationType];
      if (definition.input !== 'fullReference') {
        throw new Error('inconsistent state - column is not a reference operation');
      }
      const requirements = definition.requiredReferences[index];
      const isValid = (0, _layer_helpers.isColumnValidAsReference)({
        validation: requirements,
        column: referenceColumn
      });

      // do not enforce column validity if current column is part of managed subtree
      if (!isValid && !getFullyManagedColumnIds(layer).has(columnId)) {
        errors.push(_i18n.i18n.translate('xpack.lens.indexPattern.invalidReferenceConfiguration', {
          defaultMessage: 'Dimension "{dimensionLabel}" is configured incorrectly',
          values: {
            dimensionLabel: column.label
          }
        }));
      }
    }
  });
  return errors.length ? errors : undefined;
}
function getErrorsForDateReference(layer, columnId, name) {
  var _checkForDateHistogra, _checkReferences;
  const dateErrors = (_checkForDateHistogra = checkForDateHistogram(layer, name)) !== null && _checkForDateHistogra !== void 0 ? _checkForDateHistogra : [];
  const referenceErrors = (_checkReferences = checkReferences(layer, columnId)) !== null && _checkReferences !== void 0 ? _checkReferences : [];
  if (dateErrors.length || referenceErrors.length) {
    return [...dateErrors, ...referenceErrors];
  }
  return;
}
function hasDateField(indexPattern) {
  return indexPattern.fields.some(field => field.type === 'date');
}

/**
 * Creates an expression ast for a date based operation (cumulative sum, derivative, moving average, counter rate)
 */
function dateBasedOperationToExpression(layer, columnId, functionName, additionalArgs = {}) {
  const currentColumn = layer.columns[columnId];
  const buckets = layer.columnOrder.filter(colId => layer.columns[colId].isBucketed);
  const dateColumnIndex = buckets.findIndex(colId => layer.columns[colId].operationType === 'date_histogram');
  buckets.splice(dateColumnIndex, 1);
  return [{
    type: 'function',
    function: functionName,
    arguments: {
      by: buckets,
      inputColumnId: [currentColumn.references[0]],
      outputColumnId: [columnId],
      outputColumnName: [currentColumn.label],
      ...additionalArgs
    }
  }];
}

/**
 * Creates an expression ast for a date based operation (cumulative sum, derivative, moving average, counter rate)
 */
function optionallHistogramBasedOperationToExpression(layer, columnId, functionName, additionalArgs = {}) {
  const currentColumn = layer.columns[columnId];
  const buckets = layer.columnOrder.filter(colId => layer.columns[colId].isBucketed);
  const nonHistogramColumns = buckets.filter(colId => layer.columns[colId].operationType !== 'date_histogram' && layer.columns[colId].operationType !== 'range');
  return [{
    type: 'function',
    function: functionName,
    arguments: {
      by: nonHistogramColumns.length === buckets.length ? [] : nonHistogramColumns,
      inputColumnId: [currentColumn.references[0]],
      outputColumnId: [columnId],
      outputColumnName: [currentColumn.label],
      ...additionalArgs
    }
  }];
}
function isMetricCounterField(field) {
  return (field === null || field === void 0 ? void 0 : field.timeSeriesMetric) === 'counter';
}
function checkReferencedColumnMetric(layer, columnId, indexPattern) {
  const column = layer.columns[columnId];
  return column.references.filter(referencedId => 'sourceField' in layer.columns[referencedId]).map(referencedId => {
    const fieldName = layer.columns[referencedId].sourceField;
    if (!isMetricCounterField(indexPattern.getFieldByName(fieldName))) {
      return _i18n.i18n.translate('xpack.lens.indexPattern.invalidReferenceConfiguration', {
        defaultMessage: 'Dimension "{dimensionLabel}" is configured incorrectly',
        values: {
          dimensionLabel: layer.columns[referencedId].label
        }
      });
    }
  });
}
function getErrorForRateReference(layer, columnId, name, indexPattern) {
  var _checkForDateHistogra2, _checkReferences2, _checkReferencedColum;
  const dateErrors = (_checkForDateHistogra2 = checkForDateHistogram(layer, name)) !== null && _checkForDateHistogra2 !== void 0 ? _checkForDateHistogra2 : [];
  const referenceErrors = (_checkReferences2 = checkReferences(layer, columnId)) !== null && _checkReferences2 !== void 0 ? _checkReferences2 : [];
  const metricCounterErrors = (_checkReferencedColum = checkReferencedColumnMetric(layer, columnId, indexPattern)) !== null && _checkReferencedColum !== void 0 ? _checkReferencedColum : [];
  if (metricCounterErrors.length) {
    return metricCounterErrors.concat(referenceErrors);
  }
  if (dateErrors.length) {
    return dateErrors.concat(referenceErrors);
  }
}