"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormBasedDatasource = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class FormBasedDatasource {
  setup(core, {
    fieldFormats: fieldFormatsSetup,
    expressions,
    editorFrame,
    charts
  }) {
    editorFrame.registerDatasource(async () => {
      const {
        getFormBasedDatasource,
        getSuffixFormatter,
        suffixFormatterId
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../async_services')));
      if (!fieldFormatsSetup.has(suffixFormatterId)) {
        const startServices = (0, _public.createStartServicesGetter)(core.getStartServices);
        const suffixFormatter = getSuffixFormatter(() => startServices().plugins.fieldFormats.deserialize);
        fieldFormatsSetup.register([suffixFormatter]);
      }
      const [coreStart, {
        dataViewFieldEditor,
        uiActions,
        data,
        fieldFormats,
        dataViews,
        unifiedSearch,
        share
      }] = await core.getStartServices();
      return getFormBasedDatasource({
        core: coreStart,
        fieldFormats,
        storage: new _public.Storage(localStorage),
        data,
        unifiedSearch,
        share,
        dataViews,
        charts,
        dataViewFieldEditor,
        uiActions
      });
    });
  }
}
exports.FormBasedDatasource = FormBasedDatasource;