"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOperationSupportMatrix = void 0;
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _operations = require("../operations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function computeOperationMatrix(operationsByMetadata, filterOperations) {
  return operationsByMetadata.reduce((opsFieldTuples, {
    operationMetaData,
    operations
  }) => {
    return filterOperations(operationMetaData) ? [...opsFieldTuples, ...operations] : opsFieldTuples;
  }, []).reduce((matrix, operation) => {
    if (operation.type === 'field') {
      var _matrix$operationByFi, _matrix$fieldByOperat;
      const fieldOps = (_matrix$operationByFi = matrix.operationByField.get(operation.field)) !== null && _matrix$operationByFi !== void 0 ? _matrix$operationByFi : new Set();
      fieldOps.add(operation.operationType);
      matrix.operationByField.set(operation.field, fieldOps);
      const opFields = (_matrix$fieldByOperat = matrix.fieldByOperation.get(operation.operationType)) !== null && _matrix$fieldByOperat !== void 0 ? _matrix$fieldByOperat : new Set();
      opFields.add(operation.field);
      matrix.fieldByOperation.set(operation.operationType, opFields);
    } else {
      matrix.operationWithoutField.add(operation.operationType);
    }
    return matrix;
  }, {
    operationByField: new Map(),
    operationWithoutField: new Set(),
    fieldByOperation: new Map()
  });
}

// memoize based on latest execution. It supports multiple args
const memoizedComputeOperationsMatrix = (0, _memoizeOne.default)(computeOperationMatrix);

// TODO: the support matrix should be available outside of the dimension panel
const getOperationSupportMatrix = props => {
  const layerId = props.layerId;
  const currentIndexPattern = props.indexPatterns[props.state.layers[layerId].indexPatternId];
  const operationsByMetadata = (0, _operations.memoizedGetAvailableOperationsByMetadata)(currentIndexPattern);
  return memoizedComputeOperationsMatrix(operationsByMetadata, props.filterOperations);
};
exports.getOperationSupportMatrix = getOperationSupportMatrix;