"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formulaOperationName = exports.DimensionEditorButtonGroups = exports.CalloutWarning = void 0;
exports.getParamEditor = getParamEditor;
exports.isQuickFunction = isQuickFunction;
exports.staticValueOperationName = exports.quickFunctionsName = exports.nonQuickFunctions = void 0;
require("./dimension_editor.scss");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _operations = require("../operations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formulaOperationName = 'formula';
exports.formulaOperationName = formulaOperationName;
const staticValueOperationName = 'static_value';
exports.staticValueOperationName = staticValueOperationName;
const quickFunctionsName = 'quickFunctions';
exports.quickFunctionsName = quickFunctionsName;
const nonQuickFunctions = new Set([formulaOperationName, staticValueOperationName]);
exports.nonQuickFunctions = nonQuickFunctions;
function isQuickFunction(operationType) {
  return !nonQuickFunctions.has(operationType);
}
function getParamEditor(temporaryStaticValue, selectedOperationDefinition, showDefaultStaticValue) {
  if (temporaryStaticValue) {
    return _operations.operationDefinitionMap[staticValueOperationName].paramEditor;
  }
  if (selectedOperationDefinition !== null && selectedOperationDefinition !== void 0 && selectedOperationDefinition.paramEditor) {
    return selectedOperationDefinition.paramEditor;
  }
  if (showDefaultStaticValue) {
    return _operations.operationDefinitionMap[staticValueOperationName].paramEditor;
  }
  return null;
}
const CalloutWarning = ({
  currentOperationType,
  temporaryStateType
}) => {
  if (temporaryStateType === 'none' || currentOperationType != null && isQuickFunction(currentOperationType)) {
    return null;
  }
  if (currentOperationType === staticValueOperationName && temporaryStateType === 'quickFunctions') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      className: "lnsIndexPatternDimensionEditor__warning",
      size: "s",
      title: _i18n.i18n.translate('xpack.lens.indexPattern.staticValueWarning', {
        defaultMessage: 'Static value currently applied'
      }),
      iconType: "warning",
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.lens.indexPattern.staticValueWarningText', {
      defaultMessage: 'To overwrite your static value, select a quick function'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    className: "lnsIndexPatternDimensionEditor__warning",
    size: "s",
    title: _i18n.i18n.translate('xpack.lens.indexPattern.formulaWarning', {
      defaultMessage: 'Formula currently applied'
    }),
    iconType: "warning",
    color: "warning"
  }, temporaryStateType !== 'quickFunctions' ? /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.lens.indexPattern.formulaWarningStaticValueText', {
    defaultMessage: 'To overwrite your formula, change the value in the input field'
  })) : /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.lens.indexPattern.formulaWarningText', {
    defaultMessage: 'To overwrite your formula, select a quick function'
  }))));
};
exports.CalloutWarning = CalloutWarning;
const DimensionEditorButtonGroups = ({
  options,
  onMethodChange,
  selectedMethod
}) => {
  const enabledGroups = options.filter(({
    enabled
  }) => enabled);
  const groups = enabledGroups.map(({
    id,
    label
  }) => {
    return {
      id,
      label,
      'data-test-subj': `lens-dimensionTabs-${id}`
    };
  });
  const onChange = optionId => {
    onMethodChange(optionId);
    const selectedOption = options.find(({
      id
    }) => id === optionId);
    selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.onClick();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.indexPattern.dimensionEditor.headingMethod', {
      defaultMessage: 'Method'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.indexPattern.dimensionEditorModes', {
      defaultMessage: 'Dimension editor configuration modes'
    }),
    buttonSize: "compressed",
    isFullWidth: true,
    options: groups,
    idSelected: selectedMethod,
    onChange: id => onChange(id)
  }));
};
exports.DimensionEditorButtonGroups = DimensionEditorButtonGroups;