"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApplicationUserMessages = exports.filterAndSortUserMessages = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _i18nReact = require("@kbn/i18n-react");
var _state_helpers = require("../editor_frame_service/editor_frame/state_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides a place to register general user messages that don't belong in the datasource or visualization objects
 */
const getApplicationUserMessages = ({
  visualizationType,
  visualization,
  visualizationMap,
  activeDatasource,
  activeDatasourceState,
  dataViews,
  core
}) => {
  const messages = [];
  if (!visualizationType) {
    messages.push(getMissingVisTypeError());
  }
  if (visualization !== null && visualization !== void 0 && visualization.activeId && !visualizationMap[visualization.activeId]) {
    messages.push(getUnknownVisualizationTypeError(visualization.activeId));
  }
  if (!activeDatasource) {
    messages.push(getUnknownDatasourceTypeError());
  }
  const missingIndexPatterns = (0, _state_helpers.getMissingIndexPattern)(activeDatasource, activeDatasourceState, dataViews.indexPatterns);
  if (missingIndexPatterns.length) {
    messages.push(...getMissingIndexPatternsErrors(core, missingIndexPatterns));
  }
  return messages;
};
exports.getApplicationUserMessages = getApplicationUserMessages;
function getMissingVisTypeError() {
  return {
    severity: 'error',
    displayLocations: [{
      id: 'visualizationOnEmbeddable'
    }],
    fixableInEditor: true,
    shortMessage: '',
    longMessage: _i18n.i18n.translate('xpack.lens.editorFrame.expressionMissingVisualizationType', {
      defaultMessage: 'Visualization type not found.'
    })
  };
}
function getUnknownVisualizationTypeError(visType) {
  return {
    severity: 'error',
    fixableInEditor: false,
    displayLocations: [{
      id: 'visualization'
    }],
    shortMessage: _i18n.i18n.translate('xpack.lens.unknownVisType.shortMessage', {
      defaultMessage: `Unknown visualization type`
    }),
    longMessage: _i18n.i18n.translate('xpack.lens.unknownVisType.longMessage', {
      defaultMessage: `The visualization type {visType} could not be resolved.`,
      values: {
        visType
      }
    })
  };
}
function getUnknownDatasourceTypeError() {
  return {
    severity: 'error',
    fixableInEditor: false,
    displayLocations: [{
      id: 'visualization'
    }],
    shortMessage: _i18n.i18n.translate('xpack.lens.unknownDatasourceType.shortMessage', {
      defaultMessage: `Unknown datasource type`
    }),
    longMessage: _i18n.i18n.translate('xpack.lens.editorFrame.expressionMissingDatasource', {
      defaultMessage: 'Could not find datasource for the visualization'
    })
  };
}
function getMissingIndexPatternsErrors(core, missingIndexPatterns) {
  // Check for access to both Management app && specific indexPattern section
  const {
    management: isManagementEnabled
  } = core.application.capabilities.navLinks;
  const isIndexPatternManagementEnabled = core.application.capabilities.management.kibana.indexPatterns;
  const canFix = isManagementEnabled && isIndexPatternManagementEnabled;
  return [{
    severity: 'error',
    fixableInEditor: canFix,
    displayLocations: [{
      id: 'visualizationInEditor'
    }],
    shortMessage: '',
    longMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      className: "eui-textBreakWord",
      "data-test-subj": "missing-refs-failure"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.editorFrame.dataViewNotFound",
      defaultMessage: "Data view not found"
    })), /*#__PURE__*/_react.default.createElement("p", {
      className: "eui-textBreakWord",
      style: {
        userSelect: 'text'
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.indexPattern.missingDataView",
      defaultMessage: "The {count, plural, one {data view} other {data views}} ({count, plural, one {id} other {ids}}: {indexpatterns}) cannot be found.",
      values: {
        count: missingIndexPatterns.length,
        indexpatterns: missingIndexPatterns.join(', ')
      }
    }), canFix && /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: core
    }, /*#__PURE__*/_react.default.createElement("a", {
      href: core.application.getUrlForApp('management', {
        path: '/kibana/indexPatterns/create'
      }),
      style: {
        width: '100%',
        textAlign: 'center'
      },
      "data-test-subj": "configuration-failure-reconfigure-indexpatterns"
    }, _i18n.i18n.translate('xpack.lens.editorFrame.dataViewReconfigure', {
      defaultMessage: `Recreate it in the data view management page.`
    })))))
  }, {
    severity: 'error',
    fixableInEditor: canFix,
    displayLocations: [{
      id: 'visualizationOnEmbeddable'
    }],
    shortMessage: '',
    longMessage: _i18n.i18n.translate('xpack.lens.editorFrame.expressionMissingDataView', {
      defaultMessage: 'Could not find the {count, plural, one {data view} other {data views}}: {ids}',
      values: {
        count: missingIndexPatterns.length,
        ids: missingIndexPatterns.join(', ')
      }
    })
  }];
}
const filterAndSortUserMessages = (userMessages, locationId, {
  dimensionId,
  severity
}) => {
  const locationIds = Array.isArray(locationId) ? locationId : typeof locationId === 'string' ? [locationId] : [];
  const filteredMessages = userMessages.filter(message => {
    if (locationIds.length) {
      const hasMatch = message.displayLocations.some(location => {
        if (!locationIds.includes(location.id)) {
          return false;
        }
        return !(location.id === 'dimensionButton' && location.dimensionId !== dimensionId);
      });
      if (!hasMatch) {
        return false;
      }
    }
    if (severity && message.severity !== severity) {
      return false;
    }
    return true;
  });
  return filteredMessages.sort(bySeverity);
};
exports.filterAndSortUserMessages = filterAndSortUserMessages;
function bySeverity(a, b) {
  if (a.severity === b.severity) {
    return 0;
  }
  if (a.severity === 'error') {
    return -1;
  }
  if (b.severity === 'error') {
    return 1;
  }
  if (a.severity === 'warning') {
    return -1;
  }
  return 1;
}