"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TREE_EMPTY_STATE = exports.EmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _illustration_product_no_results_magnifying_glass = _interopRequireDefault(require("./assets/illustration_product_no_results_magnifying_glass.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TREE_EMPTY_STATE = 'kubernetesSecurity:treeEmptyState';
exports.TREE_EMPTY_STATE = TREE_EMPTY_STATE;
const panelStyle = {
  maxWidth: 500
};
const wrapperStyle = {
  height: 262
};
const EmptyState = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    "data-test-subj": TREE_EMPTY_STATE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: wrapperStyle,
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    css: panelStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.kubernetesSecurity.treeView.empty.title",
    defaultMessage: "No results match your search criteria"
  }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.kubernetesSecurity.treeView.empty.description",
    defaultMessage: "Try searching over a longer period of time or modifying your search"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "200",
    alt: "",
    url: _illustration_product_no_results_magnifying_glass.default
  })))))));
};
exports.EmptyState = EmptyState;